/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.utils;

import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public interface CountableObject<T>
extends HasPlaceholders {
    @NotNull
    public UUID getUUID();

    @NotNull
    public T getObject();

    public int getAmount();

    @NotNull
    default public MutableCountableObject<T> toMutable() {
        return CountableObject.createMutable(this.getUUID(), this.getObject(), this.getAmount());
    }

    @Override
    @NotNull
    default public PlaceholderRegistry getPlaceholdersRegistry() {
        return PlaceholderRegistry.of("amount", this.getAmount());
    }

    public static <T> CountableObject<T> create(@NotNull UUID uuid, @NotNull T object, int amount) {
        return new DummyCountableObject<T>(uuid, object, amount);
    }

    @NotNull
    public static <T> MutableCountableObject<T> createMutable(@NotNull UUID uuid, @NotNull T object, int amount) {
        return new DummyMutableCountableObject<T>(uuid, object, amount);
    }

    public static interface MutableCountableObject<T>
    extends CountableObject<T> {
        public void setObject(@NotNull T var1);

        public void setAmount(int var1);

        @NotNull
        default public CountableObject<T> toImmutable() {
            return CountableObject.create(this.getUUID(), this.getObject(), this.getAmount());
        }
    }

    public static class DummyCountableObject<T>
    implements CountableObject<T> {
        protected final UUID uuid;
        protected T object;
        protected int amount;

        public DummyCountableObject(UUID uuid, T object, int amount) {
            this.uuid = Objects.requireNonNull(uuid);
            this.object = Objects.requireNonNull(object);
            this.amount = amount;
        }

        @Override
        public UUID getUUID() {
            return this.uuid;
        }

        @Override
        public T getObject() {
            return this.object;
        }

        @Override
        public int getAmount() {
            return this.amount;
        }

        public int hashCode() {
            return this.uuid.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CountableObject)) {
                return false;
            }
            CountableObject other = (CountableObject)obj;
            return other.getUUID().equals(this.uuid);
        }
    }

    public static class DummyMutableCountableObject<T>
    extends DummyCountableObject<T>
    implements MutableCountableObject<T> {
        public DummyMutableCountableObject(UUID uuid, T object, int amount) {
            super(uuid, object, amount);
        }

        @Override
        public void setObject(T object) {
            this.object = object;
        }

        @Override
        public void setAmount(int amount) {
            this.amount = amount;
        }
    }
}

