/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CustomizedObjectTypeAdapter
extends TypeAdapter<Object> {
    public static final CustomizedObjectTypeAdapter CUSTOM_ADAPTER = new CustomizedObjectTypeAdapter();
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(Map.class, (Object)CUSTOM_ADAPTER).registerTypeAdapter(List.class, (Object)CUSTOM_ADAPTER).create();
    private final TypeAdapter<Object> delegate = new Gson().getAdapter(Object.class);

    public static <T> T deserializeNullable(String json, Class<T> classOfT) {
        if (json == null) {
            return null;
        }
        return (T)GSON.fromJson(json, classOfT);
    }

    public static String serializeNullable(Object object) {
        if (object == null) {
            return null;
        }
        return GSON.toJson(object);
    }

    private CustomizedObjectTypeAdapter() {
    }

    public void write(JsonWriter out, Object value) throws IOException {
        this.delegate.write(out, value);
    }

    public Object read(JsonReader in) throws IOException {
        JsonToken token = in.peek();
        switch (token) {
            case BEGIN_ARRAY: {
                ArrayList<Object> list = new ArrayList<Object>();
                in.beginArray();
                while (in.hasNext()) {
                    list.add(this.read(in));
                }
                in.endArray();
                return list;
            }
            case BEGIN_OBJECT: {
                LinkedTreeMap map = new LinkedTreeMap();
                in.beginObject();
                while (in.hasNext()) {
                    Object name = in.nextName();
                    try {
                        name = Integer.parseInt((String)name);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    map.put(name, this.read(in));
                }
                in.endObject();
                return map;
            }
            case STRING: {
                return in.nextString();
            }
            case NUMBER: {
                String n = in.nextString();
                if (n.indexOf(46) != -1) {
                    return Double.parseDouble(n);
                }
                try {
                    return Integer.parseInt(n);
                }
                catch (NumberFormatException e) {
                    return Long.parseLong(n);
                }
            }
            case BOOLEAN: {
                return in.nextBoolean();
            }
            case NULL: {
                in.nextNull();
                return null;
            }
        }
        throw new IllegalStateException();
    }
}

