/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.utils;

import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.utils.logger.LoggerExpanded;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class IntegrationManager
implements Listener {
    private static final LoggerExpanded LOGGER = LoggerExpanded.get("BeautyQuests.Integrations");
    private final List<BQDependency> dependencies = new ArrayList<BQDependency>();
    private boolean dependenciesTested = false;
    private boolean dependenciesInitialized = false;
    private boolean lockDependencies = false;

    public List<BQDependency> getDependencies() {
        return this.dependencies;
    }

    public void addDependency(BQDependency dependency) {
        if (this.lockDependencies) {
            LOGGER.severe("Trying to add a BQ dependency for plugin " + String.valueOf(dependency.pluginNames) + " after final locking.");
            return;
        }
        this.dependencies.add(dependency);
        if (this.dependenciesTested && dependency.testCompatibility(true) && this.dependenciesInitialized) {
            dependency.initialize();
        }
    }

    public void testCompatibilities() {
        if (this.dependenciesTested) {
            return;
        }
        this.dependencies.forEach(x -> x.testCompatibility(false));
        this.dependenciesTested = true;
    }

    public void initializeCompatibilities() {
        if (this.dependenciesInitialized) {
            return;
        }
        this.dependencies.stream().filter(BQDependency::isEnabled).forEach(BQDependency::initialize);
        this.dependenciesInitialized = true;
    }

    public void disableCompatibilities() {
        this.dependencies.forEach(BQDependency::disable);
    }

    public void lockDependencies() {
        this.lockDependencies = true;
    }

    @EventHandler
    public void onPluginEnable(PluginEnableEvent e) {
        if (this.lockDependencies) {
            return;
        }
        this.dependencies.stream().filter(x -> !x.enabled && x.isPlugin(e.getPlugin())).findAny().ifPresent(dependency -> {
            if (dependency.testCompatibility(true) && this.dependenciesInitialized) {
                dependency.initialize();
            }
        });
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        if (!this.lockDependencies) {
            return;
        }
        this.dependencies.stream().filter(x -> x.enabled && x.foundPlugin.equals((Object)event.getPlugin())).findAny().ifPresent(dependency -> {
            if (dependency.isEnabled()) {
                LOGGER.info("A plugin BeautyQuests previously hooked into ({0}) just disabled. Shutting down BeautyQuests...", event.getPlugin().getName());
                Bukkit.getPluginManager().disablePlugin((Plugin)QuestsPlugin.getPlugin());
            }
        });
    }

    public static class BQDependency {
        private final List<String> pluginNames;
        private final Runnable initialize;
        private final Runnable disable;
        private final Predicate<Plugin> isValid;
        private boolean enabled = false;
        private boolean forceDisable = false;
        private boolean initialized = false;
        private Plugin foundPlugin;

        public BQDependency(String pluginName) {
            this(pluginName, null);
        }

        public BQDependency(String pluginName, Runnable initialize) {
            this(pluginName, initialize, null, null);
        }

        public BQDependency(String pluginName, Runnable initialize, Runnable disable) {
            this(pluginName, initialize, disable, null);
        }

        public BQDependency(String pluginName, Runnable initialize, Runnable disable, Predicate<Plugin> isValid) {
            Validate.notNull((Object)pluginName);
            this.pluginNames = new ArrayList<String>();
            this.pluginNames.add(pluginName);
            this.initialize = initialize;
            this.disable = disable;
            this.isValid = isValid;
        }

        public BQDependency addPluginName(String name) {
            this.pluginNames.add(name);
            return this;
        }

        boolean isPlugin(Plugin plugin) {
            return this.pluginNames.contains(plugin.getName());
        }

        boolean testCompatibility(boolean after) {
            if (this.forceDisable) {
                return false;
            }
            Plugin plugin = this.pluginNames.stream().map(arg_0 -> ((PluginManager)Bukkit.getPluginManager()).getPlugin(arg_0)).filter(x -> x != null && x.isEnabled()).findAny().orElse(null);
            if (plugin == null) {
                return false;
            }
            if (this.isValid != null && !this.isValid.test(plugin)) {
                return false;
            }
            LOGGER.debug("Hooked into {0} v{1}" + (after ? " after primary initialization" : ""), this.pluginNames, plugin.getDescription().getVersion());
            this.enabled = true;
            this.foundPlugin = plugin;
            return true;
        }

        void initialize() {
            try {
                if (this.initialize != null) {
                    this.initialize.run();
                }
                this.initialized = true;
            }
            catch (Throwable ex) {
                LOGGER.severe("An error occurred while initializing " + this.pluginNames.toString() + " integration", ex);
                this.enabled = false;
            }
        }

        public void disable() {
            this.forceDisable = true;
            if (this.enabled) {
                this.enabled = false;
                if (this.disable != null && this.initialized) {
                    this.disable.run();
                }
                this.initialized = false;
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Plugin getFoundPlugin() {
            if (!this.enabled) {
                throw new IllegalStateException("The dependency " + String.valueOf(this.pluginNames) + " is not enabled");
            }
            return this.foundPlugin;
        }
    }
}

