/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.utils;

import com.cryptomorin.xseries.XMaterial;
import com.google.gson.GsonBuilder;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.utils.MinecraftVersion;
import fr.skytasul.quests.api.utils.PotionMapping;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.WordUtils;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinecraftNames {
    public static final String LANG_DOWNLOAD_URL = "https://github.com/InventivetalentDev/minecraft-assets/raw/%version%/assets/minecraft/lang/%language%.json";
    private static Map<String, Object> map;
    private static Map<EntityType, String> cachedEntities;
    private static Map<XMaterial, String> cachedMaterials;
    private static final boolean POTIONS_ENABLED;

    public static boolean intialize(@NotNull Path path) {
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                QuestsPlugin.getPlugin().getLoggerExpanded().warning("File " + String.valueOf(path.getFileName()) + " not found for translations.");
                return false;
            }
            map = (Map)new GsonBuilder().create().fromJson((Reader)Files.newBufferedReader(path, StandardCharsets.UTF_8), HashMap.class);
            QuestsPlugin.getPlugin().getLoggerExpanded().info("Loaded vanilla translation file for language: " + String.valueOf(map.get("language.name")) + ". Sorting values.");
            for (Map.Entry<String, Object> en : map.entrySet()) {
                String key = en.getKey();
                String value = (String)en.getValue();
                if (key.startsWith("entity.minecraft.")) {
                    cachedEntities.put(EntityType.fromName((String)key.substring(17)), value);
                    continue;
                }
                if (key.startsWith("block.minecraft.")) {
                    cachedMaterials.put(XMaterial.matchXMaterial((String)key.substring(16)).orElse(null), value);
                    continue;
                }
                if (!key.startsWith("item.minecraft.")) continue;
                String item = key.substring(15);
                if (item.startsWith("potion.effect.")) {
                    if (!POTIONS_ENABLED) continue;
                    PotionMapping.matchFromTranslationKey(item.substring(14)).forEachRemaining(potion -> potion.setNormalName(value));
                    continue;
                }
                if (item.startsWith("splash_potion.effect.")) {
                    if (!POTIONS_ENABLED) continue;
                    PotionMapping.matchFromTranslationKey(item.substring(21)).forEachRemaining(potion -> potion.setSplashName(value));
                    continue;
                }
                if (item.startsWith("lingering_potion.effect.")) {
                    if (!POTIONS_ENABLED) continue;
                    PotionMapping.matchFromTranslationKey(item.substring(24)).forEachRemaining(potion -> potion.setLingeringName(value));
                    continue;
                }
                XMaterial.matchXMaterial((String)item).ifPresent(material -> cachedMaterials.put((XMaterial)material, value));
            }
        }
        catch (Exception e) {
            QuestsPlugin.getPlugin().getLoggerExpanded().severe("Problem when loading Minecraft Translations.", e);
        }
        return true;
    }

    @Nullable
    public static Object getRaw(@Nullable String path) {
        return map.get(path);
    }

    @NotNull
    public static String getEntityName(@NotNull EntityType type) {
        String defaultName = type.getName();
        if (defaultName == null) {
            defaultName = type.name();
        }
        if (map == null) {
            return MinecraftNames.defaultFormat(defaultName);
        }
        String name = cachedEntities.get(type);
        if (name == null) {
            return MinecraftNames.defaultFormat(defaultName);
        }
        return name;
    }

    @NotNull
    public static String getMaterialName(ItemStack item) {
        PotionMeta meta;
        XMaterial type = XMaterial.matchXMaterial((ItemStack)item);
        if (POTIONS_ENABLED && (type == XMaterial.POTION || type == XMaterial.LINGERING_POTION || type == XMaterial.SPLASH_POTION) && (meta = (PotionMeta)item.getItemMeta()).getBasePotionType() != null) {
            return PotionMapping.matchFromPotionType(meta.getBasePotionType()).getTranslated(type);
        }
        return MinecraftNames.getMaterialName(type);
    }

    @NotNull
    public static String getMaterialName(@NotNull XMaterial type) {
        if (map == null) {
            return MinecraftNames.defaultFormat(type.name());
        }
        String name = cachedMaterials.get(type);
        if (name == null) {
            return MinecraftNames.defaultFormat(type.name());
        }
        return name;
    }

    @NotNull
    public static String defaultFormat(@NotNull String value) {
        return WordUtils.capitalize((String)value.toLowerCase().replace('_', ' '));
    }

    static {
        cachedEntities = new HashMap<EntityType, String>();
        cachedMaterials = new HashMap<XMaterial, String>();
        POTIONS_ENABLED = MinecraftVersion.isHigherThan(20, 5);
    }
}

