/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.utils;

import fr.skytasul.quests.api.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NumberedList<T>
implements Iterable<T>,
Cloneable {
    private Map<Integer, T> map;

    public NumberedList() {
        this.map = new HashMap<Integer, T>();
    }

    private NumberedList(Map<Integer, T> map) {
        this.map = map;
    }

    public void set(int index, T value) {
        this.map.remove(index);
        this.map.put(index, value);
    }

    public int add(T value) {
        int i = 0;
        while (this.map.get(i) != null) {
            if (++i != Integer.MAX_VALUE) continue;
            throw new InternalError("Maximum number of attempts reached.");
        }
        this.map.put(i, value);
        return i;
    }

    public T remove(int index, boolean resize) {
        T obj = null;
        HashMap<Integer, T> tmp = new HashMap<Integer, T>();
        for (Map.Entry<Integer, T> en : this.map.entrySet()) {
            int idd = en.getKey();
            if (idd < index) {
                tmp.put(idd, en.getValue());
                continue;
            }
            if (idd == index) {
                obj = en.getValue();
                continue;
            }
            tmp.put(idd - 1, en.getValue());
        }
        this.map = tmp;
        return obj;
    }

    public T remove(T value, boolean resize) {
        return this.remove((T)Utils.getKeyByValue(this.map, value), resize);
    }

    public void insert(int index, T value) {
        if (index > this.getLast()) {
            this.add(value);
            return;
        }
        HashMap<Integer, T> tmp = new HashMap<Integer, T>();
        for (Map.Entry<Integer, T> en : this.map.entrySet()) {
            int idd = en.getKey();
            if (idd < index) {
                tmp.put(idd, en.getValue());
                continue;
            }
            tmp.put(idd + 1, en.getValue());
        }
        this.map = tmp;
        this.map.put(index, value);
    }

    public int getLast() {
        int a = 0;
        int n = 0;
        int i = 0;
        while (a < this.map.size()) {
            if (this.map.get(i) != null) {
                ++a;
                n = i;
            }
            ++i;
        }
        return n;
    }

    public int valuesSize() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public T get(int index) {
        return this.map.get(index);
    }

    public int indexOf(T value) {
        return Utils.getKeyByValue(this.map, value);
    }

    public boolean contains(int id) {
        return this.map.containsKey(id);
    }

    public int clear() {
        int size = this.map.size();
        this.map.clear();
        return size;
    }

    public NumberedList<T> clone() {
        return new NumberedList<T>(new HashMap<Integer, T>(this.map));
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.values().iterator();
    }

    public Map<Integer, T> getOriginalMap() {
        return this.map;
    }

    public List<T> toList() {
        ArrayList list = new ArrayList(this.map.size());
        this.map.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(en -> list.add(en.getValue()));
        return list;
    }
}

