/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.utils;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.localization.Locale;
import org.bukkit.DyeColor;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum PlayerListCategory {
    FINISHED(1, Lang.finisheds),
    IN_PROGRESS(2, Lang.inProgress),
    NOT_STARTED(3, Lang.notStarteds);

    private final int slot;
    @NotNull
    private final Locale name;
    @NotNull
    private ItemStack icon = XMaterial.BARRIER.parseItem();
    @Nullable
    private DyeColor color = DyeColor.RED;

    private PlayerListCategory(int slot, Locale name) {
        this.slot = slot;
        this.name = name;
    }

    public int getSlot() {
        return this.slot;
    }

    @NotNull
    public String getName() {
        return this.name.getValue();
    }

    @NotNull
    public ItemStack getIcon() {
        return this.icon;
    }

    public void setIcon(@NotNull ItemStack icon) {
        this.icon = icon;
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public void setColor(@NotNull DyeColor color) {
        this.color = color;
    }

    public boolean isEnabled() {
        return QuestsConfiguration.getConfig().getQuestsMenuConfig().getEnabledTabs().contains((Object)this);
    }

    @Nullable
    public static PlayerListCategory fromString(@NotNull String name) {
        try {
            return PlayerListCategory.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

