/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.utils;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.utils.MinecraftNames;
import fr.skytasul.quests.api.utils.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PotionMapping {
    private static final List<PotionMapping> MAPPINGS = new ArrayList<PotionMapping>();
    @Nullable
    private final PotionType mappedPotion;
    @NotNull
    private final String key;
    @Nullable
    private final String duration;
    private final boolean strong;
    @NotNull
    private String normalName;
    @NotNull
    private String splashName;
    @NotNull
    private String lingeringName;

    private static void addMapping(PotionType base, String translationKey, int baseDuration, int longDuration, int strongDuration) {
        MAPPINGS.add(new PotionMapping(base, translationKey, baseDuration, false));
        try {
            MAPPINGS.add(new PotionMapping(PotionType.valueOf((String)("LONG_" + base.name())), translationKey, longDuration, true));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            MAPPINGS.add(new PotionMapping(PotionType.valueOf((String)("STRONG_" + base.name())), translationKey, strongDuration, true));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected PotionMapping(@NotNull PotionType mappedPotion, @NotNull String key, int duration, boolean strong) {
        this.mappedPotion = mappedPotion;
        this.key = key;
        this.duration = duration == -1 ? null : " (" + Utils.ticksToElapsedTime(duration) + ")";
        this.strong = strong;
        this.normalName = "potion of " + key;
        this.splashName = "splash potion of " + key;
        this.lingeringName = "lingering potion of " + key;
    }

    @NotNull
    public String getTranslated(XMaterial material) {
        Object name;
        if (material == XMaterial.POTION) {
            name = this.normalName;
        } else if (material == XMaterial.SPLASH_POTION) {
            name = this.splashName;
        } else if (material == XMaterial.LINGERING_POTION) {
            name = this.lingeringName;
        } else {
            throw new IllegalArgumentException("Argument is not a potion material");
        }
        if (this.strong) {
            name = (String)name + " II";
        }
        if (this.duration != null) {
            name = (String)name + this.duration;
        }
        return name;
    }

    public void setNormalName(@NotNull String normalName) {
        this.normalName = normalName;
    }

    public void setSplashName(@NotNull String splashName) {
        this.splashName = splashName;
    }

    public void setLingeringName(@NotNull String lingeringName) {
        this.lingeringName = lingeringName;
    }

    @NotNull
    public static Iterator<PotionMapping> matchFromTranslationKey(String key) {
        return MAPPINGS.stream().filter(mapping -> mapping.key.equals(key)).iterator();
    }

    @NotNull
    public static PotionMapping matchFromPotionType(PotionType potion) {
        for (PotionMapping mapping : MAPPINGS) {
            if (!potion.equals((Object)mapping.mappedPotion)) continue;
            return mapping;
        }
        PotionMapping.addMapping(potion, MinecraftNames.defaultFormat(potion.name()), -1, -1, -1);
        return PotionMapping.matchFromPotionType(potion);
    }

    static {
        PotionMapping.addMapping(PotionType.FIRE_RESISTANCE, "fire_resistance", 3600, 9600, -1);
        PotionMapping.addMapping(PotionType.HARMING, "harming", -1, -1, -1);
        PotionMapping.addMapping(PotionType.HEALING, "healing", -1, -1, -1);
        PotionMapping.addMapping(PotionType.STRENGTH, "strength", 3600, 9600, 1800);
        PotionMapping.addMapping(PotionType.INVISIBILITY, "invisibility", 3600, 9600, -1);
        PotionMapping.addMapping(PotionType.LEAPING, "leaping", 3600, 9600, 1800);
        PotionMapping.addMapping(PotionType.LUCK, "luck", 6000, -1, -1);
        PotionMapping.addMapping(PotionType.NIGHT_VISION, "night_vision", 3600, 9600, -1);
        PotionMapping.addMapping(PotionType.POISON, "poison", 900, 1800, 432);
        PotionMapping.addMapping(PotionType.REGENERATION, "regeneration", 900, 1800, 450);
        PotionMapping.addMapping(PotionType.SLOWNESS, "slowness", 1800, 4800, 400);
        PotionMapping.addMapping(PotionType.SLOW_FALLING, "slow_falling", 1800, 4800, -1);
        PotionMapping.addMapping(PotionType.SWIFTNESS, "swiftness", 3600, 9600, 1800);
        PotionMapping.addMapping(PotionType.WATER_BREATHING, "water_breathing", 3600, 9600, -1);
        PotionMapping.addMapping(PotionType.WEAKNESS, "weakness", 1800, 4800, -1);
        PotionMapping.addMapping(PotionType.TURTLE_MASTER, "turtle_master", 400, 800, 400);
    }
}

