/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.utils;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Utils {
    private static SimpleDateFormat cachedFormat = new SimpleDateFormat("yyyyMMddHHmmss");

    public static Optional<String> getFilenameExtension(String filename) {
        return Optional.ofNullable(filename).filter(f -> f.contains(".")).map(f -> f.substring(filename.lastIndexOf(".") + 1));
    }

    public static String ticksToElapsedTime(int ticks) {
        int i = ticks / 20;
        int j = i / 60;
        return (i %= 60) < 10 ? j + ":0" + i : j + ":" + i;
    }

    public static String millisToHumanString(long time) {
        if (time == 0L) {
            return "x";
        }
        StringBuilder sb = new StringBuilder();
        long weeks = time / 604800000L;
        if (weeks != 0L) {
            sb.append(Lang.TimeWeeks.quickFormat("weeks_amount", weeks));
        }
        long days = (time -= weeks * 604800000L) / 86400000L;
        if (sb.length() != 0) {
            sb.append(' ');
        }
        if (days != 0L) {
            sb.append(Lang.TimeDays.quickFormat("days_amount", days));
        }
        long hours = (time -= days * 86400000L) / 3600000L;
        if (sb.length() != 0) {
            sb.append(' ');
        }
        if (hours != 0L) {
            sb.append(Lang.TimeHours.quickFormat("hours_amount", hours));
        }
        long minutes = (time -= hours * 3600000L) / 60000L;
        if (sb.length() != 0) {
            sb.append(' ');
        }
        if (minutes != 0L) {
            sb.append(Lang.TimeMinutes.quickFormat("minutes_amount", minutes));
        }
        time -= minutes * 60000L;
        if (sb.length() == 0) {
            sb.append(Lang.TimeLessMinute.toString());
        }
        return sb.toString();
    }

    public static String getStringFromItemStack(ItemStack is, String amountColor, boolean showXOne) {
        return ItemUtils.getName(is, true) + (String)(is.getAmount() > 1 || showXOne ? "\u00a7r" + amountColor + " x" + is.getAmount() : "");
    }

    public static void giveItems(Player p, List<ItemStack> items) {
        HashMap leftover = p.getInventory().addItem((ItemStack[])items.stream().map(ItemStack::clone).toArray(ItemStack[]::new));
        if (!leftover.isEmpty()) {
            leftover.values().forEach(item -> p.getWorld().dropItem(p.getLocation(), item));
            Lang.ITEM_DROPPED.send((CommandSender)p);
        }
    }

    public static <T, E> T getKeyByValue(Map<T, E> map, E value) {
        if (value == null) {
            return null;
        }
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static <T, E> List<T> getKeysByValue(Map<T, E> map, E value) {
        if (value == null) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            list.add(entry.getKey());
        }
        return list;
    }

    public static long parseLong(Object obj) {
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof String) {
            return Long.parseLong((String)obj);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void walkResources(Class<?> clazz, String path, int depth, Consumer<Path> consumer) throws URISyntaxException, IOException {
        URI uri = clazz.getResource(path).toURI();
        try (FileSystem fileSystem = null;){
            Path myPath;
            if (uri.getScheme().equals("jar")) {
                fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                myPath = fileSystem.getPath(path, new String[0]);
            } else {
                myPath = Paths.get(uri);
            }
            try (Stream<Path> walker = Files.walk(myPath, depth, new FileVisitOption[0]);){
                walker.forEach(consumer);
            }
        }
    }

    public static <T> List<Map<String, Object>> serializeList(Collection<T> objects, Function<T, Map<String, Object>> serialize) {
        ArrayList<Map<String, Object>> ls = new ArrayList<Map<String, Object>>();
        for (T obj : objects) {
            ls.add(serialize.apply(obj));
        }
        return ls;
    }

    public static <T> List<T> deserializeList(List<Map<?, ?>> serialized, Function<Map<String, Object>, T> deserialize) {
        ArrayList<T> ls = new ArrayList<T>();
        if (serialized != null) {
            for (Map<?, ?> map : serialized) {
                ls.add(deserialize.apply(map));
            }
        }
        return ls;
    }

    public static Map<String, Object> mapFromConfigurationSection(ConfigurationSection section) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : section.getValues(false).entrySet()) {
            if (entry.getValue() instanceof ConfigurationSection) {
                map.put((String)entry.getKey(), Utils.mapFromConfigurationSection((ConfigurationSection)entry.getValue()));
                continue;
            }
            map.put((String)entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static ConfigurationSection createConfigurationSection(Map<String, Object> content) {
        MemoryConfiguration section = new MemoryConfiguration();
        Utils.setConfigurationSectionContent((ConfigurationSection)section, content);
        return section;
    }

    public static void setConfigurationSectionContent(ConfigurationSection section, Map<String, Object> content) {
        content.forEach((key, value) -> {
            if (value instanceof Map) {
                section.createSection(key, (Map)value);
            } else {
                section.set(key, value);
            }
        });
    }

    public static void copyConfigValue(ConfigurationSection from, String fromKey, ConfigurationSection to, String toKey) {
        if (from.isConfigurationSection(fromKey)) {
            to.createSection(toKey, Utils.mapFromConfigurationSection(from.getConfigurationSection(fromKey)));
        } else {
            to.set(toKey, from.get(fromKey));
        }
    }

    public static List<ItemStack> extractItems(List<ItemStack> items) {
        ArrayList<ItemStack> newItems = new ArrayList<ItemStack>(items.size());
        for (ItemStack original : items) {
            ItemStack item;
            int amount;
            int maxStackSize = 64;
            for (amount = original.getAmount(); amount > maxStackSize; amount -= maxStackSize) {
                item = original.clone();
                item.setAmount(maxStackSize);
                newItems.add(item);
            }
            if (amount <= 0) continue;
            item = original.clone();
            item.setAmount(amount);
            newItems.add(item);
        }
        return newItems;
    }

    public static DateFormat getDateFormat() {
        return cachedFormat;
    }

    public static String convertLocationToString(Location loc) {
        String world = loc.getWorld().getName();
        double x = loc.getX();
        double y = loc.getY();
        double z = loc.getZ();
        if ((int)loc.getPitch() != 0) {
            int yaw = (int)loc.getYaw();
            int pitch = (int)loc.getPitch();
            return world + " " + x + " " + y + " " + z + " " + yaw + " " + pitch;
        }
        return world + " " + x + " " + y + " " + z;
    }

    public static Location convertStringToLocation(String loc) {
        if (loc != null) {
            String[] coords = loc.split(" ");
            World w = Bukkit.getWorld((String)coords[0]);
            double x = Double.parseDouble(coords[1]);
            double y = Double.parseDouble(coords[2]);
            double z = Double.parseDouble(coords[3]);
            if (coords.length == 6) {
                float yaw = Float.parseFloat(coords[4]);
                float pitch = Float.parseFloat(coords[5]);
                return new Location(w, x, y, z, yaw, pitch);
            }
            return new Location(w, x, y, z);
        }
        return null;
    }

    public static boolean isQuestItem(ItemStack item) {
        ItemMeta meta;
        if (item == null) {
            return false;
        }
        String lore = Lang.QuestItemLore.toString();
        return !lore.isEmpty() && item.hasItemMeta() && (meta = item.getItemMeta()).hasLore() && meta.getLore().contains(lore);
    }

    public static <T extends Enum<T>> T valueOfEnum(Class<T> enumClass, String ... names) {
        for (String name : names) {
            try {
                return Enum.valueOf(enumClass, name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        throw new IllegalArgumentException("Cannot find " + Arrays.toString(names) + " from enum " + enumClass.getName());
    }

    public static XMaterial mobItem(EntityType type) {
        if (type == null) {
            return XMaterial.SPONGE;
        }
        Optional material = XMaterial.matchXMaterial((String)(type.name() + "_SPAWN_EGG"));
        if (material.isPresent() && ((XMaterial)material.get()).isSupported()) {
            return (XMaterial)material.get();
        }
        if (type == EntityType.WITHER) {
            return XMaterial.WITHER_SKELETON_SKULL;
        }
        if (type == EntityType.IRON_GOLEM) {
            return XMaterial.IRON_BLOCK;
        }
        if (type == EntityType.GIANT) {
            return XMaterial.ZOMBIE_SPAWN_EGG;
        }
        if (type == EntityType.ARMOR_STAND) {
            return XMaterial.ARMOR_STAND;
        }
        if (type == EntityType.PLAYER) {
            return XMaterial.PLAYER_HEAD;
        }
        if (type == EntityType.ENDER_DRAGON) {
            return XMaterial.DRAGON_HEAD;
        }
        if (type.name().equals("MUSHROOM_COW")) {
            return XMaterial.MOOSHROOM_SPAWN_EGG;
        }
        if (type.name().equals("SNOWMAN")) {
            return XMaterial.SNOW_BLOCK;
        }
        if (type.name().equals("PIG_ZOMBIE")) {
            return XMaterial.ZOMBIFIED_PIGLIN_SPAWN_EGG;
        }
        if (type.name().equals("ILLUSIONER")) {
            return XMaterial.BLAZE_POWDER;
        }
        return XMaterial.SPONGE;
    }

    public static String clickName(ClickType click) {
        switch (click) {
            case LEFT: {
                return Lang.ClickLeft.toString();
            }
            case RIGHT: {
                return Lang.ClickRight.toString();
            }
            case SHIFT_LEFT: {
                return Lang.ClickShiftLeft.toString();
            }
            case SHIFT_RIGHT: {
                return Lang.ClickShiftRight.toString();
            }
            case MIDDLE: {
                return Lang.ClickMiddle.toString();
            }
        }
        return click.name().toLowerCase();
    }

    @Nullable
    public static Entity getEntityKiller(@NotNull LivingEntity entity) {
        EntityDamageEvent entityDamageEvent = entity.getLastDamageCause();
        if (entityDamageEvent instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent event = (EntityDamageByEntityEvent)entityDamageEvent;
            return event.getDamager();
        }
        return entity.getKiller();
    }
}

