/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.utils.logger;

import fr.skytasul.quests.api.utils.messaging.DefaultErrors;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.kyori.adventure.audience.Audience;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoggerExpanded {
    @NotNull
    public static final Level DEBUG_LEVEL = new Level("DEBUG", 450){
        private static final long serialVersionUID = 4081184158724594L;
    };
    @NotNull
    private final Logger logger;
    private final Map<Object, Long> times = new HashMap<Object, Long>();

    public LoggerExpanded(@NotNull Logger logger) {
        this.logger = logger;
    }

    public void info(@Nullable String msg) {
        this.logger.info(msg);
    }

    public void info(@Nullable String msg, Object ... args) {
        this.logger.log(Level.INFO, msg, args);
    }

    public void warning(@Nullable String msg) {
        this.logger.log(Level.WARNING, msg);
    }

    public void warning(@Nullable String msg, @Nullable Throwable throwable) {
        this.logger.log(Level.WARNING, msg, throwable);
    }

    public void warning(@Nullable String msg, Object ... args) {
        this.logger.log(Level.WARNING, msg, args);
    }

    public void warning(@Nullable String msg, Throwable cause, Object ... args) {
        LogRecord log = new LogRecord(Level.WARNING, msg);
        log.setParameters(args);
        log.setThrown(cause);
        log.setLoggerName(this.logger.getName());
        this.logger.log(log);
    }

    public void namedWarning(@Nullable String msg, @NotNull Object type, int seconds, Object ... args) {
        Long time = this.times.get(type);
        if (time == null || time + (long)(seconds * 1000) < System.currentTimeMillis()) {
            this.logger.log(Level.WARNING, msg, args);
            this.times.put(type, System.currentTimeMillis());
        }
    }

    public void severe(@Nullable String msg) {
        this.logger.log(Level.SEVERE, msg);
    }

    public void severe(@Nullable String msg, @Nullable Throwable throwable) {
        this.logger.log(Level.SEVERE, msg, throwable);
    }

    public void severe(@Nullable String msg, Object ... args) {
        this.logger.log(Level.SEVERE, msg, args);
    }

    public void severe(@Nullable String msg, Throwable cause, Object ... args) {
        LogRecord log = new LogRecord(Level.SEVERE, msg);
        log.setParameters(args);
        log.setThrown(cause);
        log.setLoggerName(this.logger.getName());
        this.logger.log(log);
    }

    public void debug(@Nullable String msg) {
        this.logger.log(DEBUG_LEVEL, msg);
    }

    public void debug(@Nullable String msg, Object ... args) {
        this.logger.log(DEBUG_LEVEL, msg, args);
    }

    public void debug(@Nullable String msg, Throwable cause, Object ... args) {
        LogRecord log = new LogRecord(DEBUG_LEVEL, msg);
        log.setParameters(args);
        log.setThrown(cause);
        log.setLoggerName(this.logger.getName());
        this.logger.log(log);
    }

    public <T> BiConsumer<T, Throwable> logError(@Nullable Consumer<T> consumer, @Nullable String friendlyErrorMessage, @Nullable Audience sender, Object ... parameters) {
        return (object, ex) -> {
            if (ex == null) {
                if (consumer != null) {
                    try {
                        consumer.accept(object);
                    }
                    catch (Throwable consumerEx) {
                        this.severe(friendlyErrorMessage, consumerEx, parameters);
                        throw consumerEx;
                    }
                }
            } else {
                CompletionException exCompl;
                if (ex instanceof CompletionException && (exCompl = (CompletionException)ex).getCause() != null) {
                    ex = exCompl.getCause();
                }
                if (sender != null) {
                    DefaultErrors.sendGeneric(sender, friendlyErrorMessage);
                }
                this.severe(friendlyErrorMessage, (Throwable)ex, parameters);
            }
        };
    }

    public <T> BiConsumer<T, Throwable> logError(@Nullable String friendlyErrorMessage, @Nullable Audience sender, Object ... parameters) {
        return this.logError(null, friendlyErrorMessage, sender, parameters);
    }

    public <T> BiConsumer<T, Throwable> logError(@Nullable String friendlyErrorMessage, Object ... parameters) {
        return this.logError(null, friendlyErrorMessage, null, parameters);
    }

    public <T> BiConsumer<T, Throwable> logError() {
        return this.logError(null, null, null, new Object[0]);
    }

    @NotNull
    public static LoggerExpanded get(@NotNull String name) {
        return new LoggerExpanded(Logger.getLogger(name));
    }
}

