/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.utils.messaging;

import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.utils.ChatColorUtils;
import fr.skytasul.quests.api.utils.messaging.MessageProcessor;
import fr.skytasul.quests.api.utils.messaging.MessageType;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.api.utils.messaging.PlaceholdersContext;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MessageUtils {
    private static final Pattern RESET_PATTERN = Pattern.compile("\u00a7[rR]");
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{([a-zA-Z0-9_-]+)\\}");
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("(?:\\n|\\\\n|\\{nl\\})");

    private MessageUtils() {
    }

    public static void sendMessage(@NotNull Audience audience, @Nullable String message, @NotNull MessageType type) {
        MessageUtils.sendMessage(audience, message, type, null);
    }

    public static void sendMessage(@NotNull CommandSender sender, @Nullable String message, @NotNull MessageType type) {
        MessageUtils.sendMessage(QuestsPlugin.getPlugin().getAudiences().sender(sender), message, type);
    }

    public static void sendMessage(@NotNull Audience audience, @Nullable String message, @NotNull MessageType type, @Nullable PlaceholderRegistry placeholders) {
        MessageUtils.sendRawMessage(audience, message, placeholders, PlaceholdersContext.of(audience, true, type));
    }

    public static void sendMessage(@NotNull CommandSender sender, @Nullable String message, @NotNull MessageType type, @Nullable PlaceholderRegistry placeholders) {
        MessageUtils.sendMessage(QuestsPlugin.getPlugin().getAudiences().sender(sender), message, type, placeholders);
    }

    public static void sendRawMessage(@NotNull Audience audience, @Nullable String text, @Nullable PlaceholderRegistry placeholders, @NotNull PlaceholdersContext context) {
        if (text == null || text.isEmpty()) {
            return;
        }
        text = MessageUtils.finalFormat(text, placeholders, context);
        Object fullCompo = null;
        for (String line : NEWLINE_PATTERN.split(text)) {
            TextComponent parsed = LegacyComponentSerializer.legacySection().deserialize(line);
            fullCompo = fullCompo == null ? parsed : fullCompo.append((Component)Component.newline()).append((Component)parsed);
        }
        audience.sendMessage(fullCompo);
    }

    public static void sendRawMessage(@NotNull CommandSender sender, @Nullable String text, @Nullable PlaceholderRegistry placeholders, @NotNull PlaceholdersContext context) {
        MessageUtils.sendRawMessage(QuestsPlugin.getPlugin().getAudiences().sender(sender), text, placeholders, context);
    }

    public static String finalFormat(@NotNull String text, @Nullable PlaceholderRegistry placeholders, @NotNull PlaceholdersContext context) {
        for (MessageProcessor processor : QuestsAPI.getAPI().getMessageProcessors()) {
            placeholders = processor.processPlaceholders(placeholders, context);
            text = processor.processString(text, context);
        }
        return MessageUtils.format(text, placeholders, context);
    }

    public static String itemsToFormattedString(String[] items) {
        return MessageUtils.itemsToFormattedString(items, "");
    }

    public static String itemsToFormattedString(String[] items, String separator) {
        if (items.length == 0) {
            return "";
        }
        if (items.length == 1) {
            return items[0];
        }
        if (items.length == 2) {
            return items[0] + " " + separator + Lang.And.toString() + " " + ChatColorUtils.getLastColors(null, items[0]) + items[1];
        }
        StringBuilder stb = new StringBuilder("\u00a7e" + items[0] + ", ");
        for (int i = 1; i < items.length - 1; ++i) {
            stb.append(items[i] + (i == items.length - 2 ? "" : ", "));
        }
        stb.append(" " + Lang.And.toString() + " " + items[items.length - 1]);
        return stb.toString();
    }

    @NotNull
    public static String format(@NotNull String msg, @Nullable PlaceholderRegistry placeholders) {
        return MessageUtils.format(msg, placeholders, PlaceholdersContext.DEFAULT_CONTEXT);
    }

    @NotNull
    public static String format(@NotNull String msg, @Nullable PlaceholderRegistry placeholders, @NotNull PlaceholdersContext context) {
        if (placeholders != null) {
            Matcher matcher = PLACEHOLDER_PATTERN.matcher(Objects.requireNonNull(msg));
            StringBuilder output = null;
            int lastAppend = 0;
            String colors = "";
            while (matcher.find()) {
                if (output == null) {
                    output = new StringBuilder(msg.length());
                }
                String substring = msg.substring(lastAppend, matcher.start());
                output.append(substring);
                colors = ChatColorUtils.getLastColors(colors, substring);
                if (matcher.start() != 0 && msg.charAt(matcher.start() - 1) == '\\') {
                    output.deleteCharAt(output.length() - 1);
                    continue;
                }
                String key = matcher.group(1);
                String replacement = placeholders.resolve(key, context);
                if (replacement != null) {
                    output.append(RESET_PATTERN.matcher(replacement).replaceAll("\u00a7r" + colors));
                }
                lastAppend = matcher.end();
            }
            if (output != null) {
                output.append(msg, lastAppend, msg.length());
                msg = output.toString();
            }
        }
        return msg;
    }

    public static String getYesNo(boolean bool) {
        return (bool ? Lang.Yes : Lang.No).toString();
    }

    public static String getEnabledDisabled(boolean bool) {
        return (bool ? Lang.Enabled : Lang.Disabled).toString();
    }
}

