/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.utils.messaging;

import fr.skytasul.quests.api.utils.messaging.PlaceholdersContext;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Placeholder {
    public boolean matches(@NotNull String var1);

    @Nullable
    public String resolve(@NotNull String var1, @NotNull PlaceholdersContext var2);

    public static Placeholder of(@NotNull String key, @Nullable Object value) {
        String string = Objects.toString(value);
        return Placeholder.ofSupplier(key, () -> string);
    }

    public static Placeholder ofSupplier(final @NotNull String key, final @NotNull Supplier<@Nullable String> valueSupplier) {
        return new Placeholder(){

            @Override
            @Nullable
            public String resolve(@NotNull String key2, @NotNull PlaceholdersContext context) {
                return (String)valueSupplier.get();
            }

            @Override
            public boolean matches(@NotNull String keyToMatch) {
                return keyToMatch.equals(key);
            }
        };
    }

    public static Placeholder ofPattern(final @NotNull String regex, final @NotNull @NotNull Function<@NotNull Matcher, @Nullable String> valueFunction) {
        return new Placeholder(){
            private Pattern pattern;
            private Map<String, Matcher> matchers;
            {
                this.pattern = Pattern.compile(regex);
                this.matchers = new ConcurrentHashMap<String, Matcher>();
            }

            @Override
            @Nullable
            public String resolve(@NotNull String key, @NotNull PlaceholdersContext context) {
                Matcher matcher = this.matchers.remove(key);
                if (matcher == null && !(matcher = this.pattern.matcher(key)).matches()) {
                    throw new IllegalStateException();
                }
                return (String)valueFunction.apply(matcher);
            }

            @Override
            public boolean matches(@NotNull String key) {
                Matcher matcher = this.pattern.matcher(key);
                if (matcher.matches()) {
                    this.matchers.put(key, matcher);
                    return true;
                }
                return false;
            }
        };
    }

    public static <T extends PlaceholdersContext> Placeholder ofContextual(final @NotNull String key, final @NotNull Class<T> contextClass, final @NotNull Function<T, String> valueFunction) {
        return new ContextualizedPlaceholder<T>(){

            @Override
            public boolean matches(@NotNull String keyToMatch) {
                return keyToMatch.equals(key);
            }

            @Override
            @NotNull
            public Class<T> getContextClass() {
                return contextClass;
            }

            @Override
            @Nullable
            public String resolveContextual(@NotNull String key2, T context) {
                return (String)valueFunction.apply(context);
            }
        };
    }

    public static <T extends PlaceholdersContext> Placeholder ofPatternContextual(final @NotNull String regex, final @NotNull Class<T> contextClass, final @NotNull @NotNull BiFunction<@NotNull Matcher, @NotNull T, @Nullable String> valueFunction) {
        return new ContextualizedPlaceholder<T>(){
            private Pattern pattern;
            private Map<String, Matcher> matchers;
            {
                this.pattern = Pattern.compile(regex);
                this.matchers = new ConcurrentHashMap<String, Matcher>();
            }

            @Override
            @Nullable
            public String resolveContextual(@NotNull String key, @NotNull T context) {
                Matcher matcher = this.matchers.remove(key);
                if (matcher == null && !(matcher = this.pattern.matcher(key)).matches()) {
                    throw new IllegalStateException();
                }
                return (String)valueFunction.apply(matcher, context);
            }

            @Override
            public boolean matches(@NotNull String key) {
                Matcher matcher = this.pattern.matcher(key);
                if (matcher.matches()) {
                    this.matchers.put(key, matcher);
                    return true;
                }
                return false;
            }

            @Override
            @NotNull
            public Class<T> getContextClass() {
                return contextClass;
            }
        };
    }

    public static interface ContextualizedPlaceholder<T extends PlaceholdersContext>
    extends Placeholder {
        @NotNull
        public Class<T> getContextClass();

        @Override
        @Nullable
        default public String resolve(@NotNull String key, @NotNull PlaceholdersContext context) {
            if (!this.getContextClass().isInstance(context)) {
                throw new IllegalArgumentException("Context is not of type " + this.getContextClass().getName());
            }
            return this.resolveContextual(key, (PlaceholdersContext)this.getContextClass().cast(context));
        }

        @Nullable
        public String resolveContextual(@NotNull String var1, T var2);
    }
}

