/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.utils.messaging;

import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.api.utils.messaging.Placeholder;
import fr.skytasul.quests.api.utils.messaging.PlaceholdersContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlaceholderRegistry
implements HasPlaceholders {
    private final List<Placeholder> placeholders;
    private final List<Placeholder> indexed = new ArrayList<Placeholder>(2);

    public PlaceholderRegistry() {
        this.placeholders = new ArrayList<Placeholder>(3);
    }

    public PlaceholderRegistry(Placeholder ... placeholders) {
        this.placeholders = new ArrayList<Placeholder>(Arrays.asList(placeholders));
    }

    @Nullable
    public Placeholder getPlaceholder(@NotNull String key) {
        try {
            int index = Integer.parseInt(key);
            if (index < this.indexed.size()) {
                return this.indexed.get(index);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (Placeholder placeholder : this.placeholders) {
            if (!placeholder.matches(key)) continue;
            return placeholder;
        }
        return null;
    }

    public boolean hasPlaceholder(@NotNull String key) {
        return this.getPlaceholder(key) == null;
    }

    @Nullable
    public String resolve(@NotNull String key, @NotNull PlaceholdersContext context) {
        @Nullable Placeholder placeholder = this.getPlaceholder(key);
        if (placeholder == null) {
            return null;
        }
        return placeholder.resolve(key, context);
    }

    @Override
    @NotNull
    public PlaceholderRegistry getPlaceholdersRegistry() {
        return this;
    }

    @NotNull
    public PlaceholderRegistry register(Placeholder placeholder) {
        this.placeholders.add(placeholder);
        return this;
    }

    @NotNull
    public PlaceholderRegistry register(String key, Object value) {
        return this.register(Placeholder.of(key, value));
    }

    @NotNull
    public PlaceholderRegistry register(String key, Supplier<String> valueSupplier) {
        return this.register(Placeholder.ofSupplier(key, valueSupplier));
    }

    @NotNull
    public <T extends PlaceholdersContext> PlaceholderRegistry registerContextual(@NotNull String key, @NotNull Class<T> contextClass, @NotNull Function<T, String> valueFunction) {
        return this.register(Placeholder.ofContextual(key, contextClass, valueFunction));
    }

    @NotNull
    private PlaceholderRegistry registerIndexed(Placeholder placeholder) {
        this.placeholders.add(placeholder);
        this.indexed.add(placeholder);
        return this;
    }

    @NotNull
    public PlaceholderRegistry registerIndexed(String key, Object value) {
        return this.registerIndexed(Placeholder.of(key, value));
    }

    @NotNull
    public PlaceholderRegistry registerIndexed(String key, Supplier<String> valueSupplier) {
        return this.registerIndexed(Placeholder.ofSupplier(key, valueSupplier));
    }

    @NotNull
    public <T extends PlaceholdersContext> PlaceholderRegistry registerIndexedContextual(@NotNull String key, @NotNull Class<T> contextClass, @NotNull Function<T, String> valueFunction) {
        return this.registerIndexed(Placeholder.ofContextual(key, contextClass, valueFunction));
    }

    @NotNull
    public PlaceholderRegistry compose(HasPlaceholders ... placeholdersHolders) {
        return this.compose(true, placeholdersHolders);
    }

    @NotNull
    public PlaceholderRegistry compose(boolean withIndexes, HasPlaceholders ... placeholdersHolders) {
        for (HasPlaceholders holder : placeholdersHolders) {
            this.placeholders.addAll(holder.getPlaceholdersRegistry().placeholders);
            if (!withIndexes || holder.getPlaceholdersRegistry().indexed.isEmpty()) continue;
            this.indexed.addAll(holder.getPlaceholdersRegistry().indexed);
        }
        return this;
    }

    @NotNull
    public PlaceholderRegistry with(HasPlaceholders ... placeholdersHolders) {
        HasPlaceholders[] others = new HasPlaceholders[placeholdersHolders.length + 1];
        others[0] = this;
        System.arraycopy(placeholdersHolders, 0, others, 1, placeholdersHolders.length);
        return PlaceholderRegistry.combine(others);
    }

    @NotNull
    public PlaceholderRegistry withoutIndexes(Placeholder ... exceptedPlaceholders) {
        PlaceholderRegistry result = new PlaceholderRegistry(this.placeholders.toArray(new Placeholder[0]));
        block0: for (Placeholder placeholder : this.indexed) {
            for (Placeholder exceptedPlaceholder : exceptedPlaceholders) {
                if (exceptedPlaceholder == placeholder) continue block0;
            }
            result.indexed.add(placeholder);
        }
        return result;
    }

    @NotNull
    public PlaceholderRegistry withoutIndexes(String ... exceptedPlaceholders) {
        return this.withoutIndexes((Placeholder[])Arrays.stream(exceptedPlaceholders).map(x -> Objects.requireNonNull(this.getPlaceholder((String)x))).toArray(Placeholder[]::new));
    }

    @NotNull
    public PlaceholderRegistry shifted(@NotNull Placeholder placeholder) {
        int index = this.indexed.indexOf(placeholder);
        if (index == -1) {
            throw new IllegalArgumentException();
        }
        PlaceholderRegistry shifted = new PlaceholderRegistry();
        shifted.placeholders.addAll(this.placeholders);
        Placeholder[] indexedShifted = new Placeholder[this.indexed.size() - index];
        System.arraycopy(this.indexed.toArray(new Placeholder[this.indexed.size()]), index, indexedShifted, 0, this.indexed.size() - index);
        shifted.indexed.addAll(Arrays.asList(indexedShifted));
        return shifted;
    }

    @NotNull
    public PlaceholderRegistry shifted(@NotNull String key) {
        return this.shifted(Objects.requireNonNull(this.getPlaceholder(key)));
    }

    @NotNull
    public static PlaceholderRegistry of(@NotNull String key1, @Nullable Object value1) {
        return new PlaceholderRegistry().registerIndexed(key1, value1);
    }

    @NotNull
    public static PlaceholderRegistry of(@NotNull String key1, @Nullable Object value1, @NotNull String key2, @Nullable Object value2) {
        return new PlaceholderRegistry().registerIndexed(key1, value1).registerIndexed(key2, value2);
    }

    @NotNull
    public static PlaceholderRegistry of(@NotNull String key1, @Nullable Object value1, @NotNull String key2, @Nullable Object value2, @NotNull String key3, @Nullable Object value3) {
        return new PlaceholderRegistry().registerIndexed(key1, value1).registerIndexed(key2, value2).registerIndexed(key3, value3);
    }

    @NotNull
    public static PlaceholderRegistry combine(HasPlaceholders ... placeholdersHolders) {
        PlaceholderRegistry result = new PlaceholderRegistry();
        for (HasPlaceholders holder : placeholdersHolders) {
            result.placeholders.addAll(holder.getPlaceholdersRegistry().placeholders);
            if (holder.getPlaceholdersRegistry().indexed.isEmpty()) continue;
            result.indexed.addAll(holder.getPlaceholdersRegistry().indexed);
        }
        return result;
    }
}

