/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.utils.messaging;

import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.players.PlayerManager;
import fr.skytasul.quests.api.players.PlayerQuester;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.utils.messaging.MessageType;
import net.kyori.adventure.audience.Audience;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PlaceholdersContext {
    @NotNull
    public static final PlaceholdersContext DEFAULT_CONTEXT = PlaceholdersContext.of((Audience)null, true, null);

    @Nullable
    public Audience getAudience();

    public boolean replacePluginPlaceholders();

    @Nullable
    public MessageType getMessageType();

    public static PlaceholdersContext of(final @Nullable Audience audience, final boolean replacePluginPlaceholders, final @Nullable MessageType messageType) {
        return new PlaceholdersContext(){

            @Override
            @Nullable
            public Audience getAudience() {
                return audience;
            }

            @Override
            public boolean replacePluginPlaceholders() {
                return replacePluginPlaceholders;
            }

            @Override
            @Nullable
            public MessageType getMessageType() {
                return messageType;
            }
        };
    }

    public static PlaceholdersContext of(final @NotNull Quester quester, final boolean replacePluginPlaceholders, final @Nullable MessageType messageType) {
        return new QuesterPlaceholdersContext(){

            @Override
            @NotNull
            public Quester getQuester() {
                return quester;
            }

            @Override
            public boolean replacePluginPlaceholders() {
                return replacePluginPlaceholders;
            }

            @Override
            @Nullable
            public MessageType getMessageType() {
                return messageType;
            }
        };
    }

    public static PlayerPlaceholdersContext of(final @Nullable Player actor, final boolean replacePluginPlaceholders, final @Nullable MessageType messageType) {
        return new PlayerPlaceholdersContext(){

            @Override
            @Nullable
            public Audience getAudience() {
                return actor == null ? null : QuestsPlugin.getPlugin().getAudiences().player(actor);
            }

            @Override
            public boolean replacePluginPlaceholders() {
                return replacePluginPlaceholders;
            }

            @Override
            @NotNull
            public Player getActor() {
                return actor;
            }

            @Override
            @Nullable
            public MessageType getMessageType() {
                return messageType;
            }
        };
    }

    public static interface PlayerPlaceholdersContext
    extends QuesterPlaceholdersContext {
        @NotNull
        public Player getActor();

        @Override
        @NotNull
        default public PlayerQuester getQuester() {
            return PlayerManager.getPlayerAccount(this.getActor());
        }

        @Override
        @NotNull
        default public Audience getAudience() {
            return QuestsPlugin.getPlugin().getAudiences().player(this.getActor());
        }
    }

    public static interface QuesterPlaceholdersContext
    extends PlaceholdersContext {
        @NotNull
        public Quester getQuester();

        @Override
        @NotNull
        default public Audience getAudience() {
            return this.getQuester();
        }
    }
}

