/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.utils.progress;

import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.description.DescriptionSource;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.stages.StageDescriptionPlaceholdersContext;
import fr.skytasul.quests.api.utils.CountableObject;
import fr.skytasul.quests.api.utils.messaging.MessageType;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import fr.skytasul.quests.api.utils.messaging.Placeholder;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.api.utils.messaging.PlaceholdersContext;
import fr.skytasul.quests.api.utils.progress.HasProgress;
import fr.skytasul.quests.api.utils.progress.itemdescription.HasItemsDescriptionConfiguration;
import fr.skytasul.quests.api.utils.progress.itemdescription.ItemsDescriptionConfiguration;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProgressPlaceholders {
    private static final PlaceholderRegistry PROGRESS_REGISTRY = new PlaceholderRegistry().registerIndexedContextual("remaining", ProgressPlaceholderContext.class, context -> Long.toString(context.getProgress().getRemainingAmount(context.getQuester()))).registerIndexedContextual("done", ProgressPlaceholderContext.class, context -> Long.toString(context.getProgress().getTotalAmount() - context.getProgress().getRemainingAmount(context.getQuester()))).registerIndexedContextual("total", ProgressPlaceholderContext.class, context -> Long.toString(context.getProgress().getTotalAmount())).registerIndexedContextual("percentage", ProgressPlaceholderContext.class, context -> {
        long perc = (long)(100.0 - (double)context.getProgress().getRemainingAmount(context.getQuester()) * 100.0 / (double)context.getProgress().getTotalAmount());
        return Long.toString(perc);
    });
    private static final PlaceholderRegistry DESCRIPTION_REGISTRY = PROGRESS_REGISTRY.with(new PlaceholderRegistry().registerIndexedContextual("name", ProgressObjectPlaceholderContext.class, context -> context.getProgress().getObjectName()));

    private ProgressPlaceholders() {
    }

    public static void registerProgress(@NotNull PlaceholderRegistry placeholders, @NotNull String key, @NotNull HasProgress progress) {
        placeholders.register(Placeholder.ofPatternContextual(key + "_(remaining|done|total|percentage)", PlaceholdersContext.QuesterPlaceholdersContext.class, (matcher, context) -> PROGRESS_REGISTRY.resolve(matcher.group(1), new ProgressPlaceholderContext(context.getQuester(), context.replacePluginPlaceholders(), progress))));
    }

    public static void registerObject(@NotNull PlaceholderRegistry placeholders, @NotNull String key, @NotNull HasItemsDescriptionConfiguration.HasSingleObject object) {
        placeholders.registerIndexedContextual(key, PlaceholdersContext.QuesterPlaceholdersContext.class, context -> ProgressPlaceholders.formatObject(object, context));
        placeholders.register(Placeholder.ofPatternContextual(key + "_(remaining|done|total|percentage|name)", PlaceholdersContext.QuesterPlaceholdersContext.class, (matcher, context) -> DESCRIPTION_REGISTRY.resolve(matcher.group(1), new ProgressObjectPlaceholderContext(context.getQuester(), context.replacePluginPlaceholders(), object))));
    }

    public static <T> void registerObjects(@NotNull PlaceholderRegistry placeholders, @NotNull String key, @NotNull HasItemsDescriptionConfiguration.HasMultipleObjects<T> objects) {
        ProgressPlaceholders.registerProgress(placeholders, key, objects);
        placeholders.registerIndexedContextual(key, StageDescriptionPlaceholdersContext.class, context -> {
            Map amounts = objects.getRemainingAmounts(context.getQuester());
            String[] objectsDescription = (String[])amounts.entrySet().stream().map(entry -> ProgressPlaceholders.formatObject(ProgressPlaceholders.buildFrom(objects, (CountableObject)entry.getKey(), ((Integer)entry.getValue()).intValue()), context)).toArray(String[]::new);
            return ProgressPlaceholders.formatObjectList(context.getDescriptionSource(), objects.getItemsDescriptionConfiguration(), objectsDescription);
        });
        placeholders.register(Placeholder.ofPatternContextual(key + "_(\\d+)(?:_(remaining|done|total|percentage))?", PlaceholdersContext.QuesterPlaceholdersContext.class, (matcher, context) -> {
            int index = Integer.parseInt(matcher.group(1));
            CountableObject object = objects.getObject(index);
            if (object == null) {
                return Lang.Unknown.toString();
            }
            HasItemsDescriptionConfiguration.HasSingleObject item = ProgressPlaceholders.buildFrom(objects, object, objects.getRemainingAmount(context.getQuester(), object));
            String operation = matcher.group(2);
            if (operation == null) {
                return ProgressPlaceholders.formatObject(item, context);
            }
            return DESCRIPTION_REGISTRY.resolve(operation, new ProgressObjectPlaceholderContext(context.getQuester(), context.replacePluginPlaceholders(), item));
        }));
    }

    @NotNull
    private static <T> HasItemsDescriptionConfiguration.HasSingleObject buildFrom(final @NotNull HasItemsDescriptionConfiguration.HasMultipleObjects<T> objects, final CountableObject<T> object, final long amount) {
        return new HasItemsDescriptionConfiguration.HasSingleObject(){

            @Override
            @NotNull
            public ItemsDescriptionConfiguration getItemsDescriptionConfiguration() {
                return objects.getItemsDescriptionConfiguration();
            }

            @Override
            public long getRemainingAmount(@NotNull Quester quester) {
                return amount;
            }

            @Override
            @NotNull
            public String getObjectName() {
                return objects.getObjectName(object);
            }

            @Override
            public long getObjectAmount() {
                return object.getAmount();
            }
        };
    }

    @NotNull
    public static String formatObject(@NotNull HasItemsDescriptionConfiguration.HasSingleObject object, @NotNull PlaceholdersContext.QuesterPlaceholdersContext context) {
        String formatString = object.getRemainingAmount(context.getQuester()) > 1L ? object.getItemsDescriptionConfiguration().getMultipleItemsFormat() : object.getItemsDescriptionConfiguration().getSingleItemFormat();
        return MessageUtils.format(formatString, DESCRIPTION_REGISTRY, new ProgressObjectPlaceholderContext(context.getQuester(), context.replacePluginPlaceholders(), object));
    }

    @NotNull
    public static String formatObjectList(@NotNull DescriptionSource source, @NotNull ItemsDescriptionConfiguration configuration, String ... elements) {
        if (elements.length == 0) {
            return Lang.Unknown.toString();
        }
        if (elements.length == 1 && configuration.isAloneSplitInlined()) {
            return elements[0];
        }
        if (configuration.isSourceSplit(source)) {
            return configuration.getSplitPrefix() + String.join((CharSequence)configuration.getSplitPrefix(), elements);
        }
        return MessageUtils.itemsToFormattedString(elements, "\u00a7r");
    }

    private static class ProgressObjectPlaceholderContext
    extends ProgressPlaceholderContext {
        public ProgressObjectPlaceholderContext(@NotNull Quester quester, boolean replacePluginPlaceholders, @NotNull HasItemsDescriptionConfiguration.HasSingleObject object) {
            super(quester, replacePluginPlaceholders, object);
        }

        @Override
        @NotNull
        public HasItemsDescriptionConfiguration.HasSingleObject getProgress() {
            return (HasItemsDescriptionConfiguration.HasSingleObject)super.getProgress();
        }
    }

    private static class ProgressPlaceholderContext
    implements PlaceholdersContext.QuesterPlaceholdersContext {
        @NotNull
        private final Quester quester;
        private final boolean replacePluginPlaceholders;
        @NotNull
        private final HasProgress progress;

        public ProgressPlaceholderContext(@NotNull Quester quester, boolean replacePluginPlaceholders, @NotNull HasProgress progress) {
            this.quester = quester;
            this.replacePluginPlaceholders = replacePluginPlaceholders;
            this.progress = progress;
        }

        @Override
        @NotNull
        public Quester getQuester() {
            return this.quester;
        }

        @Override
        public boolean replacePluginPlaceholders() {
            return this.replacePluginPlaceholders;
        }

        @NotNull
        public HasProgress getProgress() {
            return this.progress;
        }

        @Override
        @Nullable
        public MessageType getMessageType() {
            return null;
        }
    }
}

