/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.utils.progress.itemdescription;

import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.utils.CountableObject;
import fr.skytasul.quests.api.utils.progress.HasProgress;
import fr.skytasul.quests.api.utils.progress.itemdescription.ItemsDescriptionConfiguration;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface HasItemsDescriptionConfiguration {
    @NotNull
    default public ItemsDescriptionConfiguration getItemsDescriptionConfiguration() {
        return QuestsConfiguration.getConfig().getStageDescriptionConfig();
    }

    public static interface HasMultipleObjects<T>
    extends HasItemsDescriptionConfiguration,
    HasProgress {
        @NotNull
        public Collection<CountableObject<T>> getObjects();

        @Nullable
        default public CountableObject<T> getObject(int index) {
            return index >= this.getObjects().size() ? null : (CountableObject)this.getObjects().toArray()[index];
        }

        @NotNull
        public String getObjectName(CountableObject<T> var1);

        @NotNull
        public Map<CountableObject<T>, Integer> getRemainingAmounts(@NotNull Quester var1);

        default public long getRemainingAmount(@NotNull Quester quester, CountableObject<T> object) {
            return this.getRemainingAmounts(quester).get(object).intValue();
        }

        @Override
        default public long getRemainingAmount(@NotNull Quester quester) {
            return this.getRemainingAmounts(quester).values().stream().mapToInt(Integer::intValue).sum();
        }

        @Override
        default public long getTotalAmount() {
            return this.getObjects().stream().mapToLong(CountableObject::getAmount).sum();
        }
    }

    public static interface HasSingleObject
    extends HasItemsDescriptionConfiguration,
    HasProgress {
        @NotNull
        public String getObjectName();

        public long getObjectAmount();

        @Override
        default public long getTotalAmount() {
            return this.getObjectAmount();
        }
    }
}

