/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.blocks;

import com.cryptomorin.xseries.XMaterial;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import fr.skytasul.quests.api.blocks.BQBlock;
import fr.skytasul.quests.api.blocks.BQBlockOptions;
import fr.skytasul.quests.api.blocks.BQBlockType;
import fr.skytasul.quests.api.blocks.BQBlocksManager;
import fr.skytasul.quests.api.stages.types.Locatable;
import fr.skytasul.quests.blocks.BQBlockData;
import fr.skytasul.quests.blocks.BQBlockMaterial;
import fr.skytasul.quests.blocks.BQBlockTag;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BQBlocksManagerImplementation
implements BQBlocksManager {
    private final BiMap<String, BQBlockType> types = HashBiMap.create((int)5);
    private BQBlockType materialType;
    private BQBlockType blockdataType;
    private BQBlockType tagType;

    public BQBlocksManagerImplementation() {
        this.registerDefaultTypes();
    }

    private void registerDefaultTypes() {
        this.materialType = (string, options) -> new BQBlockMaterial(options, XMaterial.valueOf((String)string));
        this.registerBlockType("", this.materialType);
        this.blockdataType = (string, options) -> new BQBlockData(options, Bukkit.createBlockData((String)string));
        this.registerBlockType("blockdata", this.blockdataType);
        this.tagType = (string, options) -> new BQBlockTag(options, string);
        this.registerBlockType("tag", this.tagType);
    }

    @Override
    @NotNull
    public BQBlock deserialize(@NotNull String string) throws IllegalArgumentException {
        BQBlockType type;
        int dataEnd;
        int headerSeparator = string.indexOf(":");
        int nameIndex = string.lastIndexOf("|customname:");
        String header = "";
        int dataStart = 0;
        int n = dataEnd = nameIndex == -1 ? string.length() : nameIndex;
        if (headerSeparator != -1 && (nameIndex == -1 || headerSeparator < nameIndex)) {
            header = string.substring(0, headerSeparator);
            dataStart = headerSeparator + 1;
        }
        if ((type = (BQBlockType)this.types.get((Object)header)) == null) {
            throw new IllegalArgumentException("Unknown block header: " + header);
        }
        String customName = nameIndex == -1 ? null : string.substring(nameIndex + "|customname:".length());
        return type.deserialize(string.substring(dataStart, dataEnd), new BQBlockOptions(type, customName));
    }

    @Override
    public void registerBlockType(@Nullable String header, @NotNull BQBlockType type) {
        if (this.types.containsKey((Object)header)) {
            throw new IllegalArgumentException("The block type with header " + header + " was already registered");
        }
        this.types.put((Object)header, (Object)type);
    }

    @Override
    @Nullable
    public String getHeader(@NotNull BQBlockType type) {
        return (String)this.types.inverse().get((Object)type);
    }

    @Override
    @NotNull
    public @NotNull Spliterator<@NotNull Locatable.Located> getNearbyBlocks(final @NotNull Locatable.MultipleLocatable.NearbyFetcher fetcher, final @NotNull Collection<BQBlock> types) {
        if (!fetcher.isTargeting(Locatable.LocatedType.BLOCK)) {
            return Spliterators.emptySpliterator();
        }
        final int minY = (int)Math.max((double)fetcher.getCenter().getWorld().getMinHeight(), fetcher.getCenter().getY() - fetcher.getMaxDistance());
        final double maxY = Math.min((double)fetcher.getCenter().getWorld().getMaxHeight(), fetcher.getCenter().getY() + fetcher.getMaxDistance());
        final int centerX = fetcher.getCenter().getBlockX();
        final int centerZ = fetcher.getCenter().getBlockZ();
        return Spliterators.spliteratorUnknownSize(new Iterator<Locatable.Located>(){
            int x;
            int z;
            int i;
            int y;
            Locatable.Located.LocatedBlock found;
            {
                this.x = centerX;
                this.z = centerZ;
                this.i = 0;
                this.y = minY;
                this.found = null;
            }

            private boolean findNext() {
                while ((double)this.y <= maxY) {
                    Block blockAt = fetcher.getCenter().getWorld().getBlockAt(this.x, this.y, this.z);
                    if (types.stream().anyMatch(type -> type.applies(blockAt))) {
                        this.found = Locatable.Located.LocatedBlock.create(blockAt);
                        ++this.y;
                        return true;
                    }
                    ++this.y;
                }
                if (Math.abs(this.x - centerX) <= Math.abs(this.z - centerZ) && (this.x - centerX != this.z - centerZ || this.x >= centerX)) {
                    this.x += this.z >= centerZ ? 1 : -1;
                } else {
                    this.z += this.x >= centerX ? -1 : 1;
                }
                ++this.i;
                if ((double)this.i >= fetcher.getMaxDistance() * fetcher.getMaxDistance()) {
                    return false;
                }
                this.y = minY;
                return this.findNext();
            }

            @Override
            public boolean hasNext() {
                if (this.found != null) {
                    return true;
                }
                return this.findNext();
            }

            @Override
            public Locatable.Located next() {
                if (this.found == null) {
                    this.findNext();
                }
                if (this.found != null) {
                    Locatable.Located.LocatedBlock tmpFound = this.found;
                    this.found = null;
                    return tmpFound;
                }
                throw new NoSuchElementException();
            }
        }, 1297);
    }

    @Override
    @NotNull
    public BQBlock createSimple(@NotNull XMaterial material, @Nullable String customName) {
        return new BQBlockMaterial(new BQBlockOptions(this.materialType, customName), material);
    }

    @NotNull
    public BQBlock createBlockdata(@NotNull BlockData blockData, @Nullable String customName) {
        return new BQBlockData(new BQBlockOptions(this.blockdataType, customName), blockData);
    }

    @NotNull
    public BQBlock createTag(@NotNull String tag, @Nullable String customName) {
        return new BQBlockTag(new BQBlockOptions(this.tagType, customName), tag);
    }
}

