/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.commands;

import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.commands.OutsideEditor;
import fr.skytasul.quests.api.data.DataLoadingException;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.npcs.BqNpc;
import fr.skytasul.quests.api.questers.data.QuesterData;
import fr.skytasul.quests.api.questers.data.QuesterDataManager;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.utils.MinecraftVersion;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.gui.creation.QuestCreationSession;
import fr.skytasul.quests.gui.misc.ListBook;
import fr.skytasul.quests.npcs.BqNpcImplementation;
import fr.skytasul.quests.players.AdminMode;
import fr.skytasul.quests.questers.data.sql.SqlDataManager;
import fr.skytasul.quests.structure.QuestImplementation;
import fr.skytasul.quests.utils.Database;
import fr.skytasul.quests.utils.QuestUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import revxrsal.commands.annotation.Optional;
import revxrsal.commands.annotation.SecretCommand;
import revxrsal.commands.annotation.Subcommand;
import revxrsal.commands.annotation.Switch;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;
import revxrsal.commands.bukkit.annotation.CommandPermission;
import revxrsal.commands.exception.CommandErrorException;
import revxrsal.commands.orphan.OrphanCommand;

public class CommandsAdmin
implements OrphanCommand {
    @Subcommand(value={"create"})
    @CommandPermission(value="beautyquests.command.create")
    @OutsideEditor
    public void create(Player player, @Optional Integer id) {
        QuestCreationSession session = new QuestCreationSession(player);
        if (id != null) {
            if (id < 0) {
                throw new CommandErrorException(Lang.NUMBER_NEGATIVE.toString(), new Object[0]);
            }
            if (QuestsAPI.getAPI().getQuestsManager().getQuest(id) != null) {
                throw new CommandErrorException("Invalid quest ID: another quest exists with ID " + id, new Object[0]);
            }
            session.setCustomID(id);
        }
        session.openStagesGUI(player);
    }

    @Subcommand(value={"edit"})
    @CommandPermission(value="beautyquests.command.edit")
    @OutsideEditor
    public void edit(Player player, @Optional Quest quest) {
        if (quest != null) {
            QuestCreationSession session = new QuestCreationSession(player);
            session.setQuestEdited((QuestImplementation)quest);
            session.openStagesGUI(player);
        } else {
            Lang.CHOOSE_NPC_STARTER.send((CommandSender)player);
            QuestsPlugin.getPlugin().getEditorManager().getFactory().createNpcSelection(player, () -> {}, npc -> {
                if (npc == null) {
                    return;
                }
                if (!npc.getQuests().isEmpty()) {
                    QuestsPlugin.getPlugin().getGuiManager().getFactory().createQuestSelection(clickedQuest -> {
                        QuestCreationSession session = new QuestCreationSession(player);
                        session.setQuestEdited((QuestImplementation)clickedQuest);
                        session.openStagesGUI(player);
                    }, null, npc.getQuests()).open(player);
                } else {
                    Lang.NPC_NOT_QUEST.send((CommandSender)player);
                }
            }).start();
        }
    }

    @Subcommand(value={"remove"})
    @CommandPermission(value="beautyquests.command.remove")
    @OutsideEditor
    public void remove(BukkitCommandActor actor, @Optional Quest quest) {
        if (quest != null) {
            this.doRemove(actor, quest);
        } else {
            Lang.CHOOSE_NPC_STARTER.send((CommandSender)actor.requirePlayer());
            QuestsPlugin.getPlugin().getEditorManager().getFactory().createNpcSelection(actor.asPlayer(), () -> {}, npc -> {
                if (npc == null) {
                    return;
                }
                if (!npc.getQuests().isEmpty()) {
                    QuestsPlugin.getPlugin().getGuiManager().getFactory().createQuestSelection(clickedQuest -> this.doRemove(actor, (Quest)clickedQuest), null, npc.getQuests()).open(actor.asPlayer());
                } else {
                    Lang.NPC_NOT_QUEST.send((CommandSender)actor.asPlayer());
                }
            }).start();
        }
    }

    private void doRemove(BukkitCommandActor sender, Quest quest) {
        if (sender.isPlayer()) {
            QuestsPlugin.getPlugin().getGuiManager().getFactory().createConfirmation(() -> {
                quest.delete(false, false);
                Lang.SUCCESFULLY_REMOVED.send(sender.sender(), quest);
            }, null, Lang.INDICATION_REMOVE.format((HasPlaceholders)quest), new String[0]).open(sender.asPlayer());
        } else {
            quest.delete(false, false);
            Lang.SUCCESFULLY_REMOVED.send(sender.sender(), quest);
        }
    }

    @Subcommand(value={"reload"})
    @CommandPermission(value="beautyquests.command.manage")
    public void reload(BukkitCommandActor actor) {
        BeautyQuests.getInstance().performReload(actor.sender());
    }

    @Subcommand(value={"save"})
    @CommandPermission(value="beautyquests.command.manage")
    public void save(BukkitCommandActor actor) {
        try {
            BeautyQuests.getInstance().saveAllConfig(false);
            actor.reply("\u00a7aDatas saved!");
            QuestsPlugin.getPlugin().getLoggerExpanded().info("Datas saved ~ manual save from " + actor.name());
        }
        catch (Throwable e) {
            e.printStackTrace();
            actor.error("Error while saving the data file.");
        }
    }

    @Subcommand(value={"backup"})
    @CommandPermission(value="beautyquests.command.manage")
    public void backup(BukkitCommandActor actor, @Switch boolean force) {
        if (!force) {
            this.save(actor);
        }
        try {
            BeautyQuests.getInstance().performBackup();
            Lang.BACKUP_CREATED.send(actor.sender());
        }
        catch (IOException ex) {
            Lang.BACKUP_FAILED.send(actor.sender());
            BeautyQuests.getInstance().getLoggerExpanded().warning("Failed to create backup", ex);
        }
    }

    @Subcommand(value={"adminMode"})
    @CommandPermission(value="beautyquests.command.adminMode")
    public void adminMode(BukkitCommandActor actor) {
        AdminMode.toggle(actor.sender());
    }

    @Subcommand(value={"exitEditor"})
    @SecretCommand
    public void exitEditor(Player player) {
        QuestsPlugin.getPlugin().getGuiManager().closeAndExit(player);
        QuestsPlugin.getPlugin().getEditorManager().leave(player);
    }

    @Subcommand(value={"reopenInventory"})
    @SecretCommand
    public void reopenInventory(Player player) {
        if (QuestsPlugin.getPlugin().getGuiManager().hasGuiOpened(player)) {
            QuestsPlugin.getPlugin().getGuiManager().getOpenedGui(player).open(player);
        }
    }

    @Subcommand(value={"list"})
    @CommandPermission(value="beautyquests.command.list")
    public void list(Player player) {
        ListBook.openQuestBook(player);
    }

    @Subcommand(value={"downloadTranslations"})
    @CommandPermission(value="beautyquests.command.manage")
    public void downloadTranslations(BukkitCommandActor actor, @Optional String lang, @Switch boolean overwrite) {
        if (lang == null) {
            throw new CommandErrorException(Lang.COMMAND_TRANSLATION_SYNTAX.toString(), new Object[0]);
        }
        String version = MinecraftVersion.VERSION_STRING;
        String url = "https://github.com/InventivetalentDev/minecraft-assets/raw/%version%/assets/minecraft/lang/%language%.json".replace("%version%", version).replace("%language%", lang);
        try {
            File destination = new File(BeautyQuests.getInstance().getDataFolder(), lang + ".json");
            if (destination.isDirectory()) {
                throw new CommandErrorException(Lang.ERROR_OCCURED.quickFormat("error", lang + ".json is a directory"), new Object[0]);
            }
            if (!overwrite && destination.exists()) {
                throw new CommandErrorException(Lang.COMMAND_TRANSLATION_EXISTS.quickFormat("file_name", lang + ".json"), new Object[0]);
            }
            try (ReadableByteChannel channel = Channels.newChannel(new URL(url).openStream());){
                destination.createNewFile();
                try (FileOutputStream output = new FileOutputStream(destination);){
                    output.getChannel().transferFrom(channel, 0L, Long.MAX_VALUE);
                    Lang.COMMAND_TRANSLATION_DOWNLOADED.quickSend(actor.sender(), "lang", (Object)lang);
                }
            }
            catch (FileNotFoundException ex) {
                throw new CommandErrorException(Lang.COMMAND_TRANSLATION_NOT_FOUND.format((HasPlaceholders)PlaceholderRegistry.of("lang", lang, "version", version)), new Object[0]);
            }
        }
        catch (IOException e) {
            QuestsPlugin.getPlugin().getLoggerExpanded().severe("An error occurred while downloading translation.", e);
            throw new CommandErrorException(Lang.ERROR_OCCURED.quickFormat("error", "IO Exception when downloading translation."), new Object[0]);
        }
    }

    @Subcommand(value={"migrateDatas"})
    @CommandPermission(value="beautyquests.command.manage")
    public void migrateDatas(BukkitCommandActor actor) {
        if (BeautyQuests.getInstance().getQuesterManager().getDataManager() instanceof SqlDataManager) {
            throw new CommandErrorException("\u00a7cYou can't migrate datas to a DB system if you are already using the DB system.", new Object[0]);
        }
        QuestUtils.runAsync(() -> {
            actor.reply("\u00a7aConnecting to the database.");
            try (Database db = new Database(BeautyQuests.getInstance().getConfiguration().getDatabaseConfig());){
                db.testConnection();
                actor.reply("\u00a7aConnection to database etablished.");
                Iterator<? extends QuesterData> dataIterator = BeautyQuests.getInstance().getQuesterManager().getDataManager().getAll();
                SqlDataManager targetDataManager = new SqlDataManager(db);
                targetDataManager.load(BeautyQuests.getInstance().getQuesterManager());
                try {
                    QuesterDataManager.ImportResult results = targetDataManager.importAll(dataIterator).get();
                    actor.reply("Migration done. %d questers migrated, %d failures.".formatted(results.questers(), results.failures()));
                }
                finally {
                    targetDataManager.unload();
                }
            }
            catch (DataLoadingException ex) {
                actor.error("Failed to load SQL questers data manager. " + ex.getMessage());
                QuestsPlugin.getPlugin().getLoggerExpanded().severe("Error during SQL data manager load", ex);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException ex) {
                actor.error("An exception occured during migration. Process aborted. " + ex.getMessage());
                QuestsPlugin.getPlugin().getLoggerExpanded().severe("Error during data migration", ex);
            }
            catch (IOException | SQLException ex) {
                actor.error("\u00a7cConnection to database has failed. Aborting. " + ex.getMessage());
                QuestsPlugin.getPlugin().getLoggerExpanded().severe("An error occurred while connecting to the database for datas migration.", ex);
            }
        });
    }

    @Subcommand(value={"setItem"})
    @CommandPermission(value="beautyquests.command.setItem")
    public void setItem(Player player, ItemHologram position) {
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() == Material.AIR) {
            BeautyQuests.getInstance().getDataFile().set(position.name().toLowerCase() + "Item", null);
            Lang.ITEM_REMOVED.send((CommandSender)player);
            return;
        }
        BeautyQuests.getInstance().getDataFile().set(position.name().toLowerCase() + "Item", (Object)item.serialize());
        Lang.ITEM_CHANGED.send((CommandSender)player);
    }

    @Subcommand(value={"setFirework"})
    @CommandPermission(value="beautyquests.command.setItem")
    public void setFirework(Player player, @Switch boolean remove) {
        if (remove) {
            BeautyQuests.getInstance().getDataFile().set("firework", (Object)"none");
            Lang.FIREWORK_REMOVED.send((CommandSender)player);
            Lang.RESTART_SERVER.send((CommandSender)player);
        } else {
            ItemMeta meta = player.getInventory().getItemInMainHand().getItemMeta();
            if (meta instanceof FireworkMeta) {
                BeautyQuests.getInstance().getDataFile().set("firework", (Object)meta);
                Lang.FIREWORK_EDITED.send((CommandSender)player);
                Lang.RESTART_SERVER.send((CommandSender)player);
            } else {
                Lang.FIREWORK_INVALID_HAND.send((CommandSender)player);
            }
        }
    }

    @Subcommand(value={"testNPC"})
    @CommandPermission(value="beautyquests.command.create")
    @SecretCommand
    public String testNPC(BukkitCommandActor actor, BqNpc npc) {
        ((BqNpcImplementation)npc).toggleDebug();
        return npc.toString();
    }

    public static enum ItemHologram {
        TALK,
        LAUNCH,
        NOLAUNCH;

    }
}

