/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.commands;

import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.commands.CommandsManager;
import fr.skytasul.quests.api.commands.OutsideEditor;
import fr.skytasul.quests.api.commands.QuesterSelector;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.npcs.BqNpc;
import fr.skytasul.quests.api.pools.QuestPool;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.utils.messaging.MessageType;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import fr.skytasul.quests.commands.CommandsAdmin;
import fr.skytasul.quests.commands.CommandsMisc;
import fr.skytasul.quests.commands.CommandsPlayer;
import fr.skytasul.quests.commands.CommandsPlayerManagement;
import fr.skytasul.quests.commands.CommandsPools;
import fr.skytasul.quests.commands.CommandsScoreboard;
import fr.skytasul.quests.commands.parameters.BqNpcParameter;
import fr.skytasul.quests.commands.parameters.QuestParameter;
import fr.skytasul.quests.commands.parameters.QuestPoolParameter;
import fr.skytasul.quests.commands.parameters.QuesterParameter;
import fr.skytasul.quests.commands.parameters.QuesterSelectorParameter;
import fr.skytasul.quests.scoreboards.Scoreboard;
import java.util.Arrays;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.Lamp;
import revxrsal.commands.bukkit.BukkitLamp;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;
import revxrsal.commands.exception.CommandErrorException;
import revxrsal.commands.orphan.OrphanCommand;
import revxrsal.commands.orphan.Orphans;
import revxrsal.commands.parameter.ParameterType;

public class CommandsManagerImplementation
implements CommandsManager {
    private static String[] COMMAND_ALIASES = new String[]{"quests", "quest", "bq", "beautyquests", "bquests"};
    private Lamp<BukkitCommandActor> lamp;

    public CommandsManagerImplementation(BeautyQuests plugin) {
        Lamp.Builder builder = BukkitLamp.builder((JavaPlugin)plugin);
        builder.parameterTypes(parameters -> {
            parameters.addParameterType(Quest.class, (ParameterType)new QuestParameter());
            parameters.addParameterType(QuestPool.class, (ParameterType)new QuestPoolParameter());
            parameters.addParameterType(BqNpc.class, (ParameterType)new BqNpcParameter());
            parameters.addParameterType(Quester.class, (ParameterType)new QuesterParameter(plugin.getQuesterManager(), plugin.getPlayersManager()));
            parameters.addParameterType(QuesterSelector.class, (ParameterType)new QuesterSelectorParameter(plugin.getQuesterManager(), plugin.getPlayersManager()));
            parameters.addContextParameter(Scoreboard.class, (parameter, context) -> plugin.getScoreboardManager().getPlayerScoreboard((Player)context.getResolvedArgument(Player.class)));
        });
        builder.commandCondition(context -> {
            if (!context.command().annotations().contains(OutsideEditor.class)) {
                return;
            }
            if (!((BukkitCommandActor)context.actor()).isPlayer()) {
                return;
            }
            boolean inGui = QuestsPlugin.getPlugin().getGuiManager().hasGuiOpened(((BukkitCommandActor)context.actor()).asPlayer());
            boolean inEditor = QuestsPlugin.getPlugin().getEditorManager().isInEditor(((BukkitCommandActor)context.actor()).asPlayer());
            if (inGui || inEditor) {
                throw new CommandErrorException(Lang.ALREADY_EDITOR.toString(), new Object[0]);
            }
        });
        builder.defaultMessageSender((actor, msg) -> MessageUtils.sendMessage(actor.sender(), msg, (MessageType)MessageType.DefaultMessageType.PREFIXED));
        builder.responseHandler(String.class, (msg, context) -> ((BukkitCommandActor)context.actor()).reply(msg));
        builder.hooks().onCommandExecuted((command, context, cancel) -> QuestsPlugin.getPlugin().getLoggerExpanded().debug("{0} executed command: {1}", ((BukkitCommandActor)context.actor()).name(), context.input().source()));
        this.lamp = builder.build();
    }

    public void initializeCommands() {
        this.registerCommands("", new CommandsMisc(), new CommandsAdmin(), new CommandsPlayer(), new CommandsPlayerManagement());
        this.registerCommands("scoreboard", new CommandsScoreboard());
        this.registerCommands("pools", new CommandsPools());
    }

    @Override
    @NotNull
    public Lamp<BukkitCommandActor> getHandler() {
        return this.lamp;
    }

    @Override
    public void registerCommands(String subpath, OrphanCommand ... commands) {
        Orphans path = subpath == null || subpath.isEmpty() ? Orphans.path((String[])COMMAND_ALIASES) : Orphans.path((String[])((String[])Arrays.stream(COMMAND_ALIASES).map(x -> x + " " + subpath).toArray(String[]::new)));
        this.lamp.register(Arrays.stream(commands).map(arg_0 -> ((Orphans)path).handler(arg_0)).toArray());
    }

    public void unload() {
        this.lamp.unregisterAllCommands();
    }
}

