/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.commands;

import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.players.PlayerManager;
import fr.skytasul.quests.api.players.PlayerQuester;
import fr.skytasul.quests.api.questers.data.QuesterQuestData;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.rewards.CheckpointReward;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import revxrsal.commands.annotation.CommandPlaceholder;
import revxrsal.commands.annotation.CommandPriority;
import revxrsal.commands.annotation.Subcommand;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;
import revxrsal.commands.bukkit.annotation.CommandPermission;
import revxrsal.commands.exception.UnknownCommandException;
import revxrsal.commands.orphan.OrphanCommand;

public class CommandsPlayer
implements OrphanCommand {
    @CommandPlaceholder
    @CommandPriority.Low
    @CommandPermission(value="beautyquests.command.listPlayer")
    public void menu(BukkitCommandActor actor, @revxrsal.commands.annotation.Optional String subcommand) {
        if (subcommand != null) {
            throw new UnknownCommandException(subcommand);
        }
        Player player = actor.requirePlayer();
        QuestsPlugin.getPlugin().getGuiManager().getFactory().createPlayerQuestsMenu(player).open(player);
    }

    @Subcommand(value={"checkpoint"})
    @CommandPermission(value="beautyquests.command.checkpoint")
    public void checkpoint(Player player, Quest quest) {
        PlayerQuester account = PlayerManager.getPlayerAccount(player);
        if (account.getDataHolder().hasQuestData(quest)) {
            QuesterQuestData datas = account.getDataHolder().getQuestData(quest);
            Optional<CheckpointReward> optionalCheckpoint = datas.getQuestFlowStages().map(controller -> controller.getStage().getRewards().stream().filter(CheckpointReward.class::isInstance).findAny().map(CheckpointReward.class::cast).orElse(null)).filter(Objects::nonNull).reduce((left, right) -> right);
            if (optionalCheckpoint.isPresent()) {
                optionalCheckpoint.get().apply(player);
            } else {
                Lang.COMMAND_CHECKPOINT_NO.send((CommandSender)player, quest.getPlaceholdersRegistry());
            }
        } else {
            Lang.COMMAND_CHECKPOINT_NOT_STARTED.send((CommandSender)player);
        }
    }
}

