/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.commands;

import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.commands.QuesterSelector;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.npcs.dialogs.DialogRunner;
import fr.skytasul.quests.api.players.PlayerManager;
import fr.skytasul.quests.api.players.PlayerQuester;
import fr.skytasul.quests.api.pools.QuestPool;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.questers.data.QuesterPoolData;
import fr.skytasul.quests.api.questers.data.QuesterQuestData;
import fr.skytasul.quests.api.questers.events.QuesterResetEvent;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.stages.AbstractStage;
import fr.skytasul.quests.api.stages.types.Dialogable;
import fr.skytasul.quests.api.utils.messaging.DefaultErrors;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.gui.quests.PlayerListGUI;
import fr.skytasul.quests.gui.quests.QuestsListGUI;
import fr.skytasul.quests.options.OptionStartDialog;
import fr.skytasul.quests.structure.BranchesManagerImplementation;
import fr.skytasul.quests.structure.QuestBranchImplementation;
import fr.skytasul.quests.utils.QuestUtils;
import java.util.ArrayList;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.Nullable;
import revxrsal.commands.annotation.Range;
import revxrsal.commands.annotation.Subcommand;
import revxrsal.commands.annotation.Switch;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;
import revxrsal.commands.bukkit.annotation.CommandPermission;
import revxrsal.commands.bukkit.sender.BukkitCommandPermission;
import revxrsal.commands.command.ExecutableCommand;
import revxrsal.commands.exception.CommandErrorException;
import revxrsal.commands.exception.NoPermissionException;
import revxrsal.commands.orphan.OrphanCommand;

public class CommandsPlayerManagement
implements OrphanCommand {
    private BukkitCommandPermission startOtherPermission = new BukkitCommandPermission(new Permission("beautyquests.command.start.other"));
    private BukkitCommandPermission cancelOtherPermission = new BukkitCommandPermission(new Permission("beautyquests.command.cancel.other"));

    @Subcommand(value={"finishAll"})
    @CommandPermission(value="beautyquests.command.finish")
    public void finishAll(BukkitCommandActor actor, QuesterSelector questers) {
        for (Quester quester : questers) {
            int success = 0;
            int errors = 0;
            for (Quest quest : QuestsAPI.getAPI().getQuestsManager().getQuestsStarted(quester)) {
                try {
                    quest.finish(quester);
                    ++success;
                }
                catch (Exception ex) {
                    QuestsPlugin.getPlugin().getLoggerExpanded().severe("An error occurred while finishing quest " + quest.getId(), ex);
                    ++errors;
                }
            }
            Lang.LEAVE_ALL_RESULT.send(actor.sender(), PlaceholderRegistry.of("success", success, "errors", errors));
        }
    }

    @Subcommand(value={"finish"})
    @CommandPermission(value="beautyquests.command.finish")
    public void finish(BukkitCommandActor actor, QuesterSelector questers, Quest quest, @Switch boolean force) {
        for (Quester quester : questers) {
            try {
                if (!force && !quest.hasStarted(quester)) continue;
                quest.finish(quester);
                Lang.LEAVE_ALL_RESULT.send(actor.sender(), PlaceholderRegistry.of("success", 1, "errors", 0));
            }
            catch (Exception ex) {
                QuestsPlugin.getPlugin().getLoggerExpanded().severe("An error occurred while finishing quest " + quest.getId(), ex);
                Lang.LEAVE_ALL_RESULT.send(actor.sender(), PlaceholderRegistry.of("success", 0, "errors", 1));
            }
        }
    }

    @Subcommand(value={"setStage"})
    @CommandPermission(value="beautyquests.command.setStage")
    public void setStage(BukkitCommandActor actor, Quester quester, Quest quest, @Range(min=0.0, max=14.0) @revxrsal.commands.annotation.Optional Integer branchID, @Range(min=0.0, max=14.0) @revxrsal.commands.annotation.Optional Integer stageID) {
        BranchesManagerImplementation manager = (BranchesManagerImplementation)quest.getBranchesManager();
        Optional<QuesterQuestData> dataOpt = quester.getDataHolder().getQuestDataIfPresent(quest);
        if (branchID == null && (dataOpt.isEmpty() || !dataOpt.get().hasStarted())) {
            quest.start(quester, false);
            Lang.START_QUEST.send(actor.sender(), quest, quester);
            return;
        }
        QuesterQuestData data = quester.getDataHolder().getQuestData(quest);
        QuestBranchImplementation currentBranch = (QuestBranchImplementation)quest.getBranchesManager().getPlayerBranch(quester);
        if (branchID == null) {
            if (data.getState() != QuesterQuestData.State.IN_ENDING_STAGES) {
                currentBranch.finishPlayerStage(quester, currentBranch.getRegularStage(data.getStage().getAsInt()));
                Lang.COMMAND_SETSTAGE_NEXT.send(actor.sender());
            } else {
                Lang.COMMAND_SETSTAGE_NEXT_UNAVAILABLE.send(actor.sender());
            }
        } else {
            QuestBranchImplementation targetBranch = manager.getBranch(branchID);
            if (targetBranch == null) {
                throw new CommandErrorException(Lang.COMMAND_SETSTAGE_BRANCH_DOESNTEXIST.quickFormat("branch_id", branchID), new Object[0]);
            }
            if (stageID != null) {
                if (currentBranch == null) {
                    throw new CommandErrorException(Lang.ERROR_OCCURED.quickFormat("error", "player " + quester.getDetailedName() + " has not started quest"), new Object[0]);
                }
                if (targetBranch.getRegularStages().size() <= stageID) {
                    throw new CommandErrorException(Lang.COMMAND_SETSTAGE_STAGE_DOESNTEXIST.quickFormat("stage_id", stageID), new Object[0]);
                }
            }
            Lang.COMMAND_SETSTAGE_SET.quickSend(actor.sender(), "stage_id", (Object)stageID);
            if (currentBranch != null) {
                currentBranch.remove(quester, true);
            }
            if (stageID == null) {
                targetBranch.start(quester);
            } else {
                data.setBranch(OptionalInt.of(branchID));
                targetBranch.setPlayerStage(quester, targetBranch.getRegularStage(stageID));
            }
            QuestsAPI.getAPI().propagateQuestsHandlers(handler -> handler.questUpdated(quester, quest));
        }
    }

    @Subcommand(value={"startDialog"})
    @CommandPermission(value="beautyquests.command.setStage")
    public void startDialog(BukkitCommandActor actor, Player player, Quest quest) {
        PlayerQuester acc = PlayerManager.getPlayerAccount(player);
        DialogRunner runner = null;
        if (!quest.hasStarted(acc)) {
            if (quest.hasOption(OptionStartDialog.class)) {
                runner = quest.getOption(OptionStartDialog.class).getDialogRunner();
            }
        } else {
            QuesterQuestData data = acc.getDataHolder().getQuestData(quest);
            if (data.getState() != QuesterQuestData.State.IN_REGULAR_STAGE) {
                Lang.COMMAND_STARTDIALOG_IMPOSSIBLE.send(actor.sender());
                return;
            }
            AbstractStage stage = quest.getBranchesManager().getPlayerBranch(acc).getRegularStage(data.getStage().getAsInt()).getStage();
            if (stage instanceof Dialogable) {
                Dialogable dialogable = (Dialogable)((Object)stage);
                runner = dialogable.getDialogRunner();
            }
        }
        if (runner == null) {
            Lang.COMMAND_STARTDIALOG_NO.send(actor.sender());
        } else if (runner.isPlayerInDialog(player)) {
            Lang.COMMAND_STARTDIALOG_ALREADY.send(actor.sender());
        } else {
            runner.handleNext(player, DialogRunner.DialogNextReason.COMMAND);
            Lang.COMMAND_STARTDIALOG_SUCCESS.send(actor.sender(), acc, quest);
        }
    }

    @Subcommand(value={"resetPlayer"})
    @CommandPermission(value="beautyquests.command.resetPlayer")
    public void resetPlayer(BukkitCommandActor actor, QuesterSelector questers) {
        for (Quester quester : questers) {
            CompletionStage<Boolean> future;
            ArrayList<CompletableFuture<Object>> futures = new ArrayList<CompletableFuture<Object>>();
            int quests = 0;
            int pools = 0;
            for (QuesterQuestData questerQuestData : new ArrayList<QuesterQuestData>(quester.getDataHolder().getAllQuestsData())) {
                Quest quest = questerQuestData.getQuest();
                future = quest == null ? quester.getDataHolder().removeQuestData(questerQuestData.getQuestId()) : quest.resetQuester(quester);
                future = future.whenComplete(QuestsPlugin.getPlugin().getLoggerExpanded().logError("An error occurred while resetting quest {} to {}", (Audience)actor.audience().get(), new Object[]{questerQuestData.getQuestId(), quester.getDetailedName()}));
                futures.add((CompletableFuture<Object>)future);
                ++quests;
            }
            for (QuesterPoolData questerPoolData : new ArrayList<QuesterPoolData>(quester.getDataHolder().getAllPoolsData())) {
                @Nullable QuestPool pool = questerPoolData.getPool();
                future = pool == null ? quester.getDataHolder().removePoolData(questerPoolData.getPoolId()) : pool.resetPlayer(quester);
                future = future.whenComplete(QuestsPlugin.getPlugin().getLoggerExpanded().logError("An error occurred while resetting pool {} to {}", (Audience)actor.audience().get(), new Object[]{questerPoolData.getPoolId(), quester.getDetailedName()}));
                futures.add((CompletableFuture<Object>)future);
                ++pools;
            }
            futures.add(quester.getDataHolder().resetData());
            int questsFinal = quests;
            int n = pools;
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).whenComplete(QuestUtils.runSyncConsumer(() -> {
                Bukkit.getPluginManager().callEvent((Event)new QuesterResetEvent(quester));
                Lang.DATA_REMOVED.send(quester, PlaceholderRegistry.of("quest_amount", questsFinal, "deleter_name", actor.name(), "pool_amount", poolsFinal));
                Lang.DATA_REMOVED_INFO.send(actor.sender(), PlaceholderRegistry.of("quest_amount", questsFinal, "player_name", quester.getFriendlyName(), "pool_amount", poolsFinal));
            }));
        }
    }

    @Subcommand(value={"resetPlayerQuest"})
    @CommandPermission(value="beautyquests.command.resetPlayer")
    public void resetPlayerQuest(BukkitCommandActor actor, Quester quester, @revxrsal.commands.annotation.Optional Quest quest) {
        if (quest != null) {
            this.reset(actor, quester, quest);
        } else {
            new QuestsListGUI(obj -> this.reset(actor, quester, (Quest)obj), quester, true, false, true).open(actor.requirePlayer());
        }
    }

    private void reset(BukkitCommandActor actor, Quester target, Quest qu) {
        qu.resetQuester(target).whenComplete((BiConsumer)QuestsPlugin.getPlugin().getLoggerExpanded().logError(__ -> {
            Lang.DATA_QUEST_REMOVED.send(target, qu.getPlaceholdersRegistry(), PlaceholderRegistry.of("deleter_name", actor.name()));
            Lang.DATA_QUEST_REMOVED_INFO.send((Audience)actor.audience().get(), target, qu);
        }, "An error occurred while removing player quest data", (Audience)actor.audience().get(), new Object[0]));
    }

    @Subcommand(value={"resetQuest"})
    @CommandPermission(value="beautyquests.command.resetQuest")
    public void resetQuest(BukkitCommandActor actor, Quest quest) {
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(Bukkit.getOnlinePlayers().size());
        for (Quester quester : QuestsAPI.getAPI().getQuesterManager().getLoadedQuesters()) {
            if (!quest.getQuesterStrategy().isQuesterApplicable(quester)) continue;
            futures.add(quest.resetQuester(quester).whenComplete(QuestsPlugin.getPlugin().getLoggerExpanded().logError("An error occurred while resetting quest {} to {}", (Audience)actor.audience().get(), new Object[]{quest.getId(), quester.getDetailedName()})));
        }
        ((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).whenComplete((__, ___) -> {
            int resetAmount = (int)futures.stream().filter(future -> {
                try {
                    return !future.isCompletedExceptionally() && (Boolean)future.get() != false;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
                return false;
            }).count();
            BeautyQuests.getInstance().getQuesterManager().getDataManager().resetQuestData(quest.getId()).whenComplete((BiConsumer)QuestsPlugin.getPlugin().getLoggerExpanded().logError(removedAmount -> Lang.QUEST_PLAYERS_REMOVED.quickSend(actor.sender(), "player_amount", (Object)(removedAmount + resetAmount)), "An error occurred while removing quest datas", (Audience)actor.audience().get(), new Object[0]));
        })).whenComplete(QuestsPlugin.getPlugin().getLoggerExpanded().logError());
    }

    @Subcommand(value={"seePlayer"})
    @CommandPermission(value="beautyquests.command.seePlayer")
    public void seePlayer(Player actor, Player player) {
        new PlayerListGUI(QuestsAPI.getAPI().getQuesterManager(), player, true).open(actor);
    }

    @Subcommand(value={"start"})
    @CommandPermission(value="beautyquests.command.start")
    public void start(BukkitCommandActor actor, ExecutableCommand<BukkitCommandActor> command, QuesterSelector questers, @revxrsal.commands.annotation.Optional Quest quest, @CommandPermission(value="beautyquests.command.start.other") @Switch boolean force) {
        if (actor.isPlayer() && !this.startOtherPermission.isExecutableBy(actor) && (questers.isEmpty() || questers.size() > 1 || questers.get(0) != PlayerManager.getPlayerAccount(actor.asPlayer()))) {
            throw new NoPermissionException(command);
        }
        for (Quester quester : questers) {
            if (quest == null) {
                new QuestsListGUI(obj -> this.start(actor.sender(), quester, (Quest)obj, force), quester, false, true, false).open(actor.requirePlayer());
                continue;
            }
            this.start(actor.sender(), quester, quest, force);
        }
    }

    private void start(CommandSender sender, Quester target, Quest quest, boolean force) {
        if (!force) {
            PlayerQuester playerQuester;
            if (!(target instanceof PlayerQuester) || !(playerQuester = (PlayerQuester)target).isActive()) {
                DefaultErrors.sendGeneric(BeautyQuests.getInstance().getAudiences().sender(sender), "Cannot test requirements for non-player quester");
                return;
            }
            if (!quest.canStart(playerQuester.getPlayer().get(), true)) {
                Lang.START_QUEST_NO_REQUIREMENT.send(sender, quest, target);
                return;
            }
        }
        quest.start(target, false);
        Lang.START_QUEST.send(sender, quest, target);
    }

    @Subcommand(value={"cancel"})
    @CommandPermission(value="beautyquests.command.cancel")
    public void cancel(BukkitCommandActor actor, ExecutableCommand<BukkitCommandActor> command, QuesterSelector questers, @revxrsal.commands.annotation.Optional Quest quest) {
        if (actor.isPlayer() && !this.cancelOtherPermission.isExecutableBy(actor) && (questers.isEmpty() || questers.size() > 1 || questers.get(0) != actor.asPlayer())) {
            throw new NoPermissionException(command);
        }
        for (Quester quester : questers) {
            if (quest == null) {
                new QuestsListGUI(obj -> this.cancel(actor, quester, (Quest)obj), quester, true, false, false).open(actor.requirePlayer());
                continue;
            }
            this.cancel(actor, quester, quest);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void cancel(BukkitCommandActor actor, Quester target, Quest quest) {
        if (!quest.isCancellable()) {
            Lang.CANCEL_QUEST_UNAVAILABLE.send((Audience)actor.audience().get(), quest);
            return;
        }
        if (quest.cancelQuester(target)) {
            Lang.CANCEL_QUEST.send((Audience)actor.audience().get(), quest);
            return;
        }
        if (actor.isPlayer() && target instanceof PlayerQuester) {
            PlayerQuester playerQuester = (PlayerQuester)target;
            if (actor.asPlayer().equals(playerQuester.getPlayer().orElse(null))) {
                Lang.QUEST_NOT_STARTED.send((Audience)actor.audience().get());
                return;
            }
        }
        DefaultErrors.sendGeneric((Audience)actor.audience().get(), "Quester " + target.getFriendlyName() + " does not have the quest " + quest.getId() + " started.");
    }
}

