/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.commands;

import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.players.PlayerManager;
import fr.skytasul.quests.api.players.PlayerQuester;
import fr.skytasul.quests.api.pools.QuestPool;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.gui.pools.PoolsManageGUI;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import revxrsal.commands.annotation.CommandPlaceholder;
import revxrsal.commands.annotation.Subcommand;
import revxrsal.commands.annotation.Switch;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;
import revxrsal.commands.bukkit.annotation.CommandPermission;
import revxrsal.commands.bukkit.parameters.EntitySelector;
import revxrsal.commands.orphan.OrphanCommand;

public class CommandsPools
implements OrphanCommand {
    @CommandPlaceholder
    @CommandPermission(value="beautyquests.command.pools")
    public void pools(Player player) {
        PoolsManageGUI.get().open(player);
    }

    @Subcommand(value={"resetPlayer"})
    @CommandPermission(value="beautyquests.command.resetPlayer")
    public void resetPlayerPool(BukkitCommandActor actor, Player player, QuestPool pool, @Switch boolean timer) {
        PlayerQuester acc = PlayerManager.getPlayerAccount(player);
        if (timer) {
            pool.resetPlayerTimer(acc);
            Lang.POOL_RESET_TIMER.send(actor.sender(), pool, acc);
        } else {
            pool.resetPlayer(acc).whenComplete((BiConsumer)QuestsPlugin.getPlugin().getLoggerExpanded().logError(__ -> Lang.POOL_RESET_FULL.send(actor.sender(), pool, acc), "An error occurred while resetting pool " + pool.getId() + " to player " + player.getName(), (Audience)actor.audience().get(), new Object[0]));
        }
    }

    @Subcommand(value={"reset"})
    @CommandPermission(value="beautyquests.command.resetQuest")
    public void resetPool(BukkitCommandActor actor, QuestPool pool) {
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(Bukkit.getOnlinePlayers().size());
        for (Player p : Bukkit.getOnlinePlayers()) {
            futures.add(pool.resetPlayer(PlayerManager.getPlayerAccount(p)).whenComplete(QuestsPlugin.getPlugin().getLoggerExpanded().logError("An error occurred while resetting pool " + pool.getId() + " to player " + p.getName(), (Audience)actor.audience().get(), new Object[0])));
        }
        ((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).whenComplete((__, ___) -> {
            int resetAmount = (int)futures.stream().filter(future -> {
                try {
                    return !future.isCompletedExceptionally() && (Boolean)future.get() != false;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
                return false;
            }).count();
            BeautyQuests.getInstance().getQuesterManager().getDataManager().resetPoolData(pool.getId()).whenComplete((BiConsumer)QuestsPlugin.getPlugin().getLoggerExpanded().logError(removedAmount -> Lang.POOL_COMPLETELY_RESET.quickSend(actor.sender(), "player_amount", (Object)(removedAmount + resetAmount)), "An error occurred while removing pool datas", (Audience)actor.audience().get(), new Object[0]));
        })).whenComplete(QuestsPlugin.getPlugin().getLoggerExpanded().logError());
    }

    @Subcommand(value={"start"})
    @CommandPermission(value="beautyquests.command.pools.start")
    public void start(BukkitCommandActor actor, EntitySelector<Player> players, QuestPool pool) {
        for (Player player : players) {
            PlayerQuester acc = PlayerManager.getPlayerAccount(player);
            if (!pool.canGive(player).result()) {
                Lang.POOL_START_ERROR.send((CommandSender)player, pool, acc);
                return;
            }
            pool.give(player).whenComplete((BiConsumer)QuestsPlugin.getPlugin().getLoggerExpanded().logError(result -> Lang.POOL_START_SUCCESS.send(actor.sender(), pool, acc, PlaceholderRegistry.of("result", result)), "Failed to give pool {} to {}", acc, pool.getId(), acc.getDetailedName()));
        }
    }
}

