/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.commands.parameters;

import fr.skytasul.quests.api.players.PlayerManager;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.questers.QuesterManager;
import fr.skytasul.quests.api.questers.QuesterProvider;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.autocomplete.SuggestionProvider;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;
import revxrsal.commands.bukkit.exception.EmptyEntitySelectorException;
import revxrsal.commands.exception.CommandErrorException;
import revxrsal.commands.node.ExecutionContext;
import revxrsal.commands.parameter.ParameterType;
import revxrsal.commands.stream.MutableStringStream;

public class QuesterParameter
implements ParameterType<BukkitCommandActor, Quester> {
    private static final Pattern FULL_IDENTIFIER_PATTERN = Pattern.compile("^([a-z0-9_.-]+:[a-z0-9/._-]+)\\|(.*)$");
    @NotNull
    private final QuesterManager questerManager;
    @NotNull
    private final PlayerManager playerManager;

    public QuesterParameter(@NotNull QuesterManager questerManager, @NotNull PlayerManager playerManager) {
        this.questerManager = questerManager;
        this.playerManager = playerManager;
    }

    public Quester parse(@NotNull MutableStringStream input, @NotNull ExecutionContext<BukkitCommandActor> context) {
        String string = input.readString();
        Player player = Bukkit.getPlayer((String)string);
        if (player != null) {
            return this.playerManager.getQuester(player);
        }
        return QuesterParameter.parseQuester(string, this.questerManager).orElseThrow(() -> new EmptyEntitySelectorException(string));
    }

    @NotNull
    public @NotNull SuggestionProvider<@NotNull BukkitCommandActor> defaultSuggestions() {
        return new SuggestionProviderImplementation(this.questerManager, this.playerManager);
    }

    public static Optional<Quester> parseQuester(@NotNull String string, @NotNull QuesterManager questerManager) {
        Matcher questerMatcher = FULL_IDENTIFIER_PATTERN.matcher(string);
        if (questerMatcher.matches()) {
            QuesterProvider provider;
            Key providerKey = Key.key((String)questerMatcher.group(1));
            try {
                provider = questerManager.getQuesterProvider(providerKey);
            }
            catch (IllegalArgumentException ex) {
                throw new CommandErrorException("%s is not a known quester provider".formatted(providerKey), new Object[0]);
            }
            String identifier = questerMatcher.group(2);
            for (Quester quester : provider.getLoadedQuesters()) {
                if (!quester.getIdentifier().equals(identifier)) continue;
                return Optional.of(quester);
            }
            throw new EmptyEntitySelectorException(string);
        }
        return Optional.empty();
    }

    protected static class SuggestionProviderImplementation
    implements SuggestionProvider<BukkitCommandActor> {
        @NotNull
        private final QuesterManager questerManager;
        @NotNull
        private final PlayerManager playerManager;

        public SuggestionProviderImplementation(@NotNull QuesterManager questerManager, @NotNull PlayerManager playerManager) {
            this.questerManager = questerManager;
            this.playerManager = playerManager;
        }

        @NotNull
        public Collection<String> getSuggestions(@NotNull @NotNull ExecutionContext<@NotNull BukkitCommandActor> context) {
            List<String> list = Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
            for (QuesterProvider questerProvider : this.questerManager.getQuesterProviders()) {
                if (questerProvider == this.playerManager) continue;
                for (Quester quester : questerProvider.getLoadedQuesters()) {
                    list.add(questerProvider.key().asString() + "|" + quester.getIdentifier());
                }
            }
            return list;
        }
    }
}

