/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.commands.parameters;

import fr.skytasul.quests.api.commands.QuesterSelector;
import fr.skytasul.quests.api.players.PlayerManager;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.questers.QuesterManager;
import fr.skytasul.quests.commands.parameters.QuesterParameter;
import fr.skytasul.quests.commands.parameters.QuesterSelectorImpl;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.autocomplete.SuggestionProvider;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;
import revxrsal.commands.bukkit.exception.EmptyEntitySelectorException;
import revxrsal.commands.node.ExecutionContext;
import revxrsal.commands.parameter.ParameterType;
import revxrsal.commands.stream.MutableStringStream;

public class QuesterSelectorParameter
implements ParameterType<BukkitCommandActor, QuesterSelector> {
    @NotNull
    private final QuesterManager questerManager;
    @NotNull
    private final PlayerManager playerManager;

    public QuesterSelectorParameter(@NotNull QuesterManager questerManager, @NotNull PlayerManager playerManager) {
        this.questerManager = questerManager;
        this.playerManager = playerManager;
    }

    public QuesterSelector parse(@NotNull MutableStringStream input, @NotNull ExecutionContext<BukkitCommandActor> context) {
        String string = input.readString();
        Optional<Quester> questerOpt = QuesterParameter.parseQuester(string, this.questerManager);
        if (questerOpt.isPresent()) {
            return new QuesterSelectorImpl(List.of(questerOpt.get()));
        }
        List entities = Bukkit.selectEntities((CommandSender)((BukkitCommandActor)context.actor()).sender(), (String)string);
        List<Player> players = entities.stream().filter(Player.class::isInstance).map(Player.class::cast).toList();
        if (players.isEmpty()) {
            throw new EmptyEntitySelectorException(string);
        }
        return new QuesterSelectorImpl(players.stream().map(x -> this.playerManager.getQuester((Player)x)).toList());
    }

    @NotNull
    public @NotNull SuggestionProvider<@NotNull BukkitCommandActor> defaultSuggestions() {
        return new QuesterParameter.SuggestionProviderImplementation(this.questerManager, this.playerManager);
    }
}

