/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.editor;

import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.editors.Editor;
import fr.skytasul.quests.api.editors.EditorFactory;
import fr.skytasul.quests.api.editors.EditorManager;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.utils.messaging.DefaultErrors;
import fr.skytasul.quests.editor.DefaultEditorFactory;
import fr.skytasul.quests.utils.QuestUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;

public class EditorManagerImplementation
implements EditorManager,
Listener {
    @NotNull
    private final Map<Player, Editor> players = new HashMap<Player, Editor>();
    @NotNull
    private final BossBar bar = BossBar.bossBar((Component)Component.text((String)"Quests Editor", (TextColor)NamedTextColor.GOLD), (float)0.0f, (BossBar.Color)BossBar.Color.YELLOW, (BossBar.Overlay)BossBar.Overlay.PROGRESS);
    @NotNull
    private EditorFactory factory;

    public EditorManagerImplementation() {
        this.setFactory(new DefaultEditorFactory());
    }

    @Override
    public <T extends Editor> T start(@NotNull T editor) {
        Player player = editor.getPlayer();
        if (this.isInEditor(player)) {
            Lang.ALREADY_EDITOR.send((CommandSender)player);
            throw new IllegalStateException(player.getName() + " is already in an editor");
        }
        this.players.put(player, editor);
        QuestsPlugin.getPlugin().getGuiManager().closeAndExit(player);
        QuestsPlugin.getPlugin().getLoggerExpanded().debug(player.getName() + " is entering editor " + editor.getClass().getName() + ".");
        player.sendTitle(Lang.ENTER_EDITOR_TITLE.toString(), Lang.ENTER_EDITOR_SUB.toString(), 5, 50, 5);
        QuestsPlugin.getPlugin().getAudiences().player(player).showBossBar(this.bar);
        QuestUtils.autoRegister(editor);
        try {
            editor.begin();
        }
        catch (Exception ex) {
            QuestsPlugin.getPlugin().getLoggerExpanded().severe("An error occurred while beginning editor", ex);
            DefaultErrors.sendGeneric(QuestsPlugin.getPlugin().getAudiences().player(player), "impossible to begin editor");
            editor.cancel();
        }
        return editor;
    }

    @Override
    public void leave(@NotNull Player player) {
        Editor editor = this.players.remove(player);
        if (editor == null) {
            return;
        }
        QuestsPlugin.getPlugin().getLoggerExpanded().debug(player.getName() + " has left the editor.");
        QuestsPlugin.getPlugin().getAudiences().player(player).hideBossBar(this.bar);
        editor.end();
        QuestUtils.autoUnregister(editor);
    }

    @Override
    public void leaveAll() {
        new ArrayList<Player>(this.players.keySet()).forEach(this::leave);
    }

    @Override
    public boolean isInEditor(@NotNull Player player) {
        return this.players.containsKey(player);
    }

    @Override
    @NotNull
    public EditorFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(@NotNull EditorFactory factory) {
        this.factory = factory;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=false)
    public void onChat(AsyncPlayerChatEvent e) {
        Editor editor = this.players.get(e.getPlayer());
        if (editor == null) {
            return;
        }
        e.setCancelled(true);
        QuestUtils.runOrSync(() -> editor.callChat(e.getMessage()));
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        this.leave(e.getPlayer());
    }
}

