/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.editor.parsers;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.editors.parsers.AbstractParser;
import fr.skytasul.quests.api.localization.Lang;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MaterialParser
implements AbstractParser<XMaterial> {
    private boolean item;
    private boolean block;

    public MaterialParser(boolean item, boolean block) {
        this.item = item;
        this.block = block;
    }

    @Override
    public XMaterial parse(Player p, String msg) throws Throwable {
        XMaterial tmp = XMaterial.matchXMaterial((String)msg).orElse(null);
        if (tmp == null) {
            Material mat = Material.matchMaterial((String)msg);
            if (mat != null) {
                tmp = XMaterial.matchXMaterial((Material)mat);
            }
            if (tmp == null) {
                if (this.block) {
                    Lang.UNKNOWN_BLOCK_TYPE.send((CommandSender)p);
                } else {
                    Lang.UNKNOWN_ITEM_TYPE.send((CommandSender)p);
                }
                return null;
            }
        }
        if (this.item) {
            if (!tmp.get().isItem()) {
                Lang.INVALID_ITEM_TYPE.send((CommandSender)p);
                return null;
            }
        } else if (this.block && !tmp.get().isBlock()) {
            Lang.INVALID_BLOCK_TYPE.send((CommandSender)p);
            return null;
        }
        return tmp;
    }
}

