/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui;

import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.blocks.BQBlock;
import fr.skytasul.quests.api.comparison.ItemComparisonMap;
import fr.skytasul.quests.api.gui.Gui;
import fr.skytasul.quests.api.gui.GuiFactory;
import fr.skytasul.quests.api.gui.templates.ConfirmGUI;
import fr.skytasul.quests.api.npcs.BqNpc;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.utils.CountableObject;
import fr.skytasul.quests.gui.blocks.BlocksGUI;
import fr.skytasul.quests.gui.items.ItemComparisonGUI;
import fr.skytasul.quests.gui.items.ItemCreatorGUI;
import fr.skytasul.quests.gui.items.ItemGUI;
import fr.skytasul.quests.gui.items.ItemsGUI;
import fr.skytasul.quests.gui.mobs.EntityTypeGUI;
import fr.skytasul.quests.gui.npc.NpcSelectGUI;
import fr.skytasul.quests.gui.quests.ChoosePlayerQuestGUI;
import fr.skytasul.quests.gui.quests.ChooseQuestGUI;
import fr.skytasul.quests.gui.quests.PlayerListGUI;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultGuiFactory
implements GuiFactory {
    @Override
    @NotNull
    public Gui createPlayerQuestsMenu(@NotNull Player player) {
        return new PlayerListGUI(BeautyQuests.getInstance().getQuesterManager(), player, false);
    }

    @Override
    @NotNull
    public Gui createItemSelection(@NotNull Consumer<ItemStack> callback, boolean allowCancel) {
        return new ItemGUI(callback, allowCancel);
    }

    @Override
    @NotNull
    public Gui createItemCreator(@NotNull Consumer<ItemStack> callback, boolean allowCancel) {
        return new ItemCreatorGUI(callback, allowCancel);
    }

    @Override
    @NotNull
    public Gui createItemsSelection(@NotNull @NotNull Consumer<@NotNull List<@NotNull ItemStack>> callback, @Nullable @Nullable List<@Nullable ItemStack> existingItems) {
        return new ItemsGUI(callback, existingItems);
    }

    @Override
    @NotNull
    public Gui createItemComparisonsSelection(@NotNull ItemComparisonMap comparisons, @NotNull Runnable validate) {
        return new ItemComparisonGUI(comparisons, validate);
    }

    @Override
    @NotNull
    public Gui createBlocksSelection(@NotNull Consumer<List<CountableObject.MutableCountableObject<BQBlock>>> callback, @NotNull Collection<CountableObject.MutableCountableObject<BQBlock>> existingBlocks) {
        return new BlocksGUI(existingBlocks, callback);
    }

    @Override
    @NotNull
    public Gui createNpcSelection(@NotNull Runnable cancel, @NotNull Consumer<BqNpc> callback, boolean nullable) {
        return NpcSelectGUI.select(cancel, callback, nullable);
    }

    @Override
    @NotNull
    public Gui createConfirmation(@Nullable Runnable yes, @Nullable Runnable no, @NotNull String indication, @Nullable @Nullable List<@Nullable String> lore) {
        return ConfirmGUI.confirm(yes, no, indication, lore);
    }

    @Override
    @NotNull
    public Gui createEntityTypeSelection(@NotNull Consumer<EntityType> callback, @Nullable Predicate<@NotNull EntityType> filter) {
        return new EntityTypeGUI(callback, filter);
    }

    @Override
    @NotNull
    public Gui createQuestSelection(@NotNull Consumer<Quest> callback, @Nullable Runnable cancel, @NotNull Collection<Quest> quests) {
        return new ChooseQuestGUI(quests, callback, cancel);
    }

    @Override
    @NotNull
    public Gui createPlayerQuestSelection(@NotNull Player player, @NotNull Collection<Quest> quests) {
        return new ChoosePlayerQuestGUI(quests, player);
    }
}

