/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui;

import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.gui.Gui;
import fr.skytasul.quests.api.gui.GuiClickEvent;
import fr.skytasul.quests.api.gui.GuiFactory;
import fr.skytasul.quests.api.gui.GuiManager;
import fr.skytasul.quests.api.gui.ItemFactory;
import fr.skytasul.quests.api.gui.close.CloseBehavior;
import fr.skytasul.quests.api.gui.close.DelayCloseBehavior;
import fr.skytasul.quests.api.gui.close.OpenCloseBehavior;
import fr.skytasul.quests.api.gui.close.StandardCloseBehavior;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.utils.messaging.DefaultErrors;
import fr.skytasul.quests.gui.DefaultGuiFactory;
import fr.skytasul.quests.gui.DefaultItemFactory;
import fr.skytasul.quests.utils.QuestUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiManagerImplementation
implements GuiManager,
Listener {
    private Map<Player, Gui> players = new HashMap<Player, Gui>();
    private boolean dismissClose = false;
    private GuiFactory factory;
    private ItemFactory itemFactory;

    public GuiManagerImplementation() {
        this.setFactory(new DefaultGuiFactory());
        this.setItemFactory(new DefaultItemFactory());
    }

    @Override
    public void open(@NotNull Player player, @NotNull Gui inventory) {
        try {
            this.closeWithoutExit(player);
            QuestsPlugin.getPlugin().getLoggerExpanded().debug(player.getName() + " has opened inventory " + inventory.getClass().getName() + ".");
            inventory.showInternal(player);
            this.players.put(player, inventory);
        }
        catch (Exception ex) {
            QuestsPlugin.getPlugin().getLoggerExpanded().severe("Cannot open inventory " + inventory.getClass().getSimpleName() + " to player " + player.getName(), ex);
            this.closeAndExit(player);
        }
    }

    @Override
    public void closeAndExit(@NotNull Player player) {
        this.players.remove(player);
        player.closeInventory();
    }

    @Override
    public void closeWithoutExit(@NotNull Player player) {
        this.dismissClose = true;
        player.closeInventory();
        this.dismissClose = false;
    }

    @Override
    public void closeAll() {
        Iterator<Player> iterator = this.players.keySet().iterator();
        while (iterator.hasNext()) {
            Player player = iterator.next();
            iterator.remove();
            player.closeInventory();
        }
    }

    @Override
    public boolean hasGuiOpened(@NotNull Player player) {
        return this.players.containsKey(player);
    }

    @Override
    @Nullable
    public Gui getOpenedGui(@NotNull Player player) {
        return this.players.get(player);
    }

    @Override
    @NotNull
    public GuiFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(@NotNull GuiFactory factory) {
        this.factory = factory;
    }

    @Override
    @NotNull
    public ItemFactory getItemFactory() {
        return this.itemFactory;
    }

    @Override
    public void setItemFactory(@NotNull ItemFactory factory) {
        this.itemFactory = factory;
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        if (this.dismissClose) {
            this.dismissClose = false;
            return;
        }
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        Gui gui = this.players.get(player);
        if (gui == null) {
            return;
        }
        this.ensureSameInventory(gui, event.getInventory());
        CloseBehavior behavior = gui.onClose(player);
        if (behavior instanceof StandardCloseBehavior) {
            switch ((StandardCloseBehavior)behavior) {
                case CONFIRM: {
                    QuestUtils.runSync(() -> this.factory.createConfirmation(() -> this.closeAndExit(player), () -> this.open(player, gui), Lang.INDICATION_CLOSE.toString(), new String[0]).open(player));
                    break;
                }
                case NOTHING: {
                    break;
                }
                case REMOVE: {
                    this.players.remove(player);
                    break;
                }
                case REOPEN: {
                    QuestUtils.runSync(() -> this.open(player, gui));
                }
            }
        } else if (behavior instanceof DelayCloseBehavior) {
            this.players.remove(player);
            QuestUtils.runSync(((DelayCloseBehavior)behavior).getDelayed());
        } else if (behavior instanceof OpenCloseBehavior) {
            this.open(player, ((OpenCloseBehavior)behavior).getOther());
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Gui gui = this.players.get(player);
        if (gui == null) {
            return;
        }
        event.setCancelled(false);
        try {
            if (event.getClickedInventory() == player.getInventory()) {
                if (event.isShiftClick()) {
                    event.setCancelled(true);
                }
                return;
            }
            if (event.getClickedInventory() == null) {
                return;
            }
            ClickType click = event.getClick();
            if (click == ClickType.NUMBER_KEY || click == ClickType.DOUBLE_CLICK || click == ClickType.DROP || click == ClickType.CONTROL_DROP || click.name().equals("SWAP_OFFHAND")) {
                event.setCancelled(true);
                return;
            }
            this.ensureSameInventory(gui, event.getClickedInventory());
            if (event.getCursor().getType() == Material.AIR && (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR)) {
                return;
            }
            GuiClickEvent guiEvent = new GuiClickEvent(player, gui, event.getCurrentItem(), event.getCursor(), event.getSlot(), event.getClick());
            gui.onClick(guiEvent);
            event.setCancelled(guiEvent.isCancelled());
        }
        catch (Exception ex) {
            event.setCancelled(true);
            DefaultErrors.sendGeneric(QuestsPlugin.getPlugin().getAudiences().player(player), ex.getMessage() + " in " + gui.getClass().getSimpleName());
            QuestsPlugin.getPlugin().getLoggerExpanded().severe("An error occurred when " + player.getName() + " clicked in inventory " + gui.getClass().getName() + " at slot " + event.getSlot(), ex);
        }
    }

    @EventHandler
    public void onDrag(InventoryDragEvent event) {
        if (this.players.containsKey(event.getWhoClicked())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onOpen(InventoryOpenEvent event) {
        if (event.isCancelled() && this.players.containsKey(event.getPlayer())) {
            QuestsPlugin.getPlugin().getLoggerExpanded().warning("The opening of a BeautyQuests menu for player " + event.getPlayer().getName() + " has been cancelled by another plugin.");
        }
    }

    private void ensureSameInventory(Gui gui, Inventory inventory) {
        if (gui.getInventory() != inventory) {
            String expectedName = gui.getInventory().getType().name() + " (" + gui.getClass().getSimpleName() + ")";
            String foundName = inventory == null ? "null" : inventory.getType().name();
            QuestsPlugin.getPlugin().getLoggerExpanded().debug("Player shall have a " + expectedName + " inventory but had a " + foundName + " inventory.");
            throw new IllegalStateException("The inventory opened by the player is not the same as the one registered by the plugin");
        }
    }
}

