/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.blocks;

import fr.skytasul.quests.api.blocks.BQBlock;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.templates.ListGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.utils.CountableObject;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.gui.blocks.SelectBlockGUI;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.DyeColor;
import org.bukkit.inventory.ItemStack;

public class BlocksGUI
extends ListGUI<CountableObject.MutableCountableObject<BQBlock>> {
    private Consumer<List<CountableObject.MutableCountableObject<BQBlock>>> end;

    public BlocksGUI(Collection<CountableObject.MutableCountableObject<BQBlock>> blocks, Consumer<List<CountableObject.MutableCountableObject<BQBlock>>> end) {
        super(Lang.INVENTORY_BLOCKSLIST.toString(), DyeColor.GREEN, blocks);
        this.end = end;
    }

    @Override
    public void finish(List<CountableObject.MutableCountableObject<BQBlock>> objects) {
        this.end.accept(objects);
    }

    @Override
    public void createObject(Function<CountableObject.MutableCountableObject<BQBlock>, ItemStack> callback) {
        new SelectBlockGUI(true, (type, amount) -> {
            UUID uuid = UUID.nameUUIDFromBytes(type.getAsString().getBytes());
            callback.apply(CountableObject.createMutable(uuid, type, amount));
        }).open(this.player);
    }

    @Override
    public ItemStack getObjectItemStack(CountableObject.MutableCountableObject<BQBlock> object) {
        return ItemUtils.item(((BQBlock)object.getObject()).getMaterial(), Lang.materialName.format((HasPlaceholders)object.getObject()), this.createLoreBuilder(object).addDescription(Lang.Amount.format((HasPlaceholders)object)).toLoreArray());
    }
}

