/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.blocks;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.blocks.BQBlock;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.editors.parsers.NumberParser;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.close.StandardCloseBehavior;
import fr.skytasul.quests.api.gui.layout.LayoutedButton;
import fr.skytasul.quests.api.gui.layout.LayoutedClickEvent;
import fr.skytasul.quests.api.gui.layout.LayoutedGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.utils.nms.NMS;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SelectBlockGUI
extends LayoutedGUI.LayoutedRowsGUI {
    private BiConsumer<BQBlock, Integer> run;
    private XMaterial type = XMaterial.STONE;
    private String customName = null;
    private String blockData = null;
    private String tag = null;
    private int amount = 1;

    public SelectBlockGUI(boolean allowAmount, BiConsumer<BQBlock, Integer> run) {
        super(Lang.INVENTORY_BLOCK.toString(), new HashMap<Integer, LayoutedButton>(), StandardCloseBehavior.REOPEN, 1);
        this.run = run;
        if (allowAmount) {
            this.buttons.put(1, LayoutedButton.create(XMaterial.REDSTONE, () -> Lang.Amount.quickFormat("amount", this.amount), Collections.emptyList(), this::amountClick));
        }
        this.buttons.put(2, LayoutedButton.create(XMaterial.NAME_TAG, Lang.blockName.toString(), Arrays.asList(QuestOption.formatNullableValue((Object)this.customName, this.customName == null)), this::nameClick));
        this.buttons.put(4, new LayoutedButton(){

            @Override
            public void click(@NotNull LayoutedClickEvent event) {
                SelectBlockGUI.this.typeClick(event);
            }

            @Override
            public void place(@NotNull Inventory inventory, int slot) {
                XMaterial mat = SelectBlockGUI.this.type;
                if (!SelectBlockGUI.this.type.get().isItem()) {
                    mat = XMaterial.STONE;
                }
                this.placeInternal(inventory, slot, mat);
                if (SelectBlockGUI.this.tag == null) {
                    ItemUtils.setGlittering(inventory.getItem(slot), true);
                }
            }

            private void placeInternal(@NotNull Inventory inventory, int slot, @NotNull XMaterial material) {
                ItemStack item = ItemUtils.item(material, Lang.materialName.quickFormat("block_type", SelectBlockGUI.this.type.name()), new String[0]);
                if (material != SelectBlockGUI.this.type) {
                    ItemUtils.lore(item, QuestOption.formatDescription(Lang.materialNotItemLore.quickFormat("block_type", SelectBlockGUI.this.type.name())));
                }
                inventory.setItem(slot, item);
                item = inventory.getItem(slot);
                if (item == null || item.getType() == Material.AIR) {
                    this.placeInternal(inventory, slot, XMaterial.STONE);
                }
            }
        });
        this.buttons.put(5, LayoutedButton.create(() -> {
            ItemStack item = ItemUtils.item(XMaterial.COMMAND_BLOCK, Lang.blockData.toString(), QuestOption.formatNullableValue((Object)this.blockData, this.blockData == null));
            if (this.blockData != null) {
                ItemUtils.setGlittering(item, true);
            }
            return item;
        }, this::dataClick));
        this.buttons.put(6, LayoutedButton.create(() -> {
            ItemStack item = ItemUtils.item(XMaterial.FILLED_MAP, Lang.blockTag.toString(), QuestOption.formatDescription(Lang.blockTagLore.toString()), "", QuestOption.formatNullableValue((Object)this.tag, this.tag == null));
            if (this.tag != null) {
                ItemUtils.setGlittering(item, true);
            }
            return item;
        }, this::tagClick));
        this.buttons.put(8, LayoutedButton.create(QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getDone(), this::doneClick));
    }

    private void amountClick(LayoutedClickEvent event) {
        Lang.BLOCKS_AMOUNT.send((CommandSender)event.getPlayer());
        new TextEditor<Integer>(event.getPlayer(), event::reopen, obj -> {
            this.amount = obj;
            event.refreshItemReopen();
        }, NumberParser.INTEGER_PARSER_STRICT_POSITIVE).start();
    }

    private void nameClick(LayoutedClickEvent event) {
        Lang.BLOCK_NAME.send((CommandSender)event.getPlayer());
        new TextEditor<String>(event.getPlayer(), event::reopen, obj -> {
            this.customName = obj;
            event.refreshItemReopen();
        }).passNullIntoEndConsumer().start();
    }

    private void typeClick(LayoutedClickEvent event) {
        Lang.BLOCK_NAME.send((CommandSender)event.getPlayer());
        new TextEditor<XMaterial>(event.getPlayer(), event::reopen, type -> {
            this.type = type;
            if (this.blockData != null) {
                try {
                    Bukkit.createBlockData((Material)type.parseMaterial(), (String)this.blockData);
                }
                catch (Exception ex) {
                    Lang.INVALID_BLOCK_DATA.send((CommandSender)event.getPlayer(), PlaceholderRegistry.of("block_data", this.blockData, "block_material", type.name()));
                    this.blockData = null;
                }
            }
            event.refreshGuiReopen();
        }, QuestsPlugin.getPlugin().getEditorManager().getFactory().getMaterialParser(false, true)).start();
    }

    private void dataClick(LayoutedClickEvent event) {
        Lang.BLOCK_DATA.quickSend((CommandSender)event.getPlayer(), "available_datas", (Object)String.join((CharSequence)", ", NMS.getNMS().getAvailableBlockProperties(this.type.parseMaterial())));
        new TextEditor<Object>(event.getPlayer(), event::reopen, obj -> {
            String tmp = "[" + String.valueOf(obj) + "]";
            try {
                Bukkit.createBlockData((Material)this.type.parseMaterial(), (String)tmp);
                this.blockData = tmp;
                this.tag = null;
            }
            catch (Exception ex) {
                Lang.INVALID_BLOCK_DATA.send((CommandSender)event.getPlayer(), PlaceholderRegistry.of("block_data", tmp, "block_material", this.type.name()));
            }
            event.refreshGuiReopen();
        }, () -> {
            this.blockData = null;
            event.refreshGuiReopen();
        }).useStrippedMessage().start();
    }

    private void tagClick(LayoutedClickEvent event) {
        String tagList = NMS.getNMS().getAvailableBlockTags().stream().map(key -> {
            if (key.namespace() == "minecraft") {
                return key.value();
            }
            return key.asString();
        }).sorted().collect(Collectors.joining(", "));
        Lang.BLOCK_TAGS.quickSend((CommandSender)event.getPlayer(), "available_tags", (Object)tagList);
        new TextEditor<Object>(event.getPlayer(), event::reopen, obj -> {
            NamespacedKey key = NamespacedKey.fromString((String)((String)obj));
            if (key == null || Bukkit.getTag((String)"blocks", (NamespacedKey)key, Material.class) == null) {
                Lang.INVALID_BLOCK_TAG.quickSend((CommandSender)event.getPlayer(), "block_tag", obj);
            } else {
                this.tag = (String)obj;
                this.type = XMaterial.STONE;
                this.blockData = null;
            }
            event.refreshGuiReopen();
        }).useStrippedMessage().start();
    }

    private void doneClick(LayoutedClickEvent event) {
        event.close();
        BQBlock block = this.blockData != null ? BeautyQuests.getInstance().getAPI().getBlocksManager().createBlockdata(Bukkit.createBlockData((Material)this.type.parseMaterial(), (String)this.blockData), this.customName) : (this.tag != null ? BeautyQuests.getInstance().getAPI().getBlocksManager().createTag(this.tag, this.customName) : BeautyQuests.getInstance().getAPI().getBlocksManager().createSimple(this.type, this.customName));
        this.run.accept(block, this.amount);
    }
}

