/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.creation;

import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.gui.creation.quest.QuestCreationGuiImplementation;
import fr.skytasul.quests.gui.creation.stages.StagesGUI;
import fr.skytasul.quests.structure.QuestImplementation;
import net.kyori.adventure.audience.Audience;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class QuestCreationSession {
    private StagesGUI stagesGUI;
    private QuestCreationGuiImplementation creationGUI;
    @NotNull
    private final Player player;
    private QuestImplementation questEdited;
    private boolean stagesEdited = false;
    private int customID = -1;

    public QuestCreationSession(@NotNull Player player) {
        this.player = player;
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    public Audience getPlayerAudience() {
        return QuestsPlugin.getPlugin().getAudiences().player(this.player);
    }

    public boolean hasCustomID() {
        return this.customID != -1;
    }

    public int getCustomID() {
        return this.customID;
    }

    public void setCustomID(int customID) {
        this.customID = customID;
    }

    public boolean isEdition() {
        return this.questEdited != null;
    }

    public QuestImplementation getQuestEdited() {
        return this.questEdited;
    }

    public void setQuestEdited(QuestImplementation questEdited) {
        this.questEdited = questEdited;
    }

    public void setStagesEdited() {
        this.stagesEdited = true;
    }

    public boolean areStagesEdited() {
        return this.isEdition() && this.stagesEdited;
    }

    public StagesGUI getStagesGUI() {
        return this.stagesGUI;
    }

    public void openStagesGUI(Player p) {
        if (this.stagesGUI == null) {
            this.stagesGUI = new StagesGUI(this);
        }
        this.stagesGUI.open(p);
    }

    public void openCreationGUI(Player p) {
        if (this.creationGUI == null) {
            this.creationGUI = new QuestCreationGuiImplementation(this);
        }
        this.creationGUI.open(p);
    }
}

