/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.creation.quest;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.close.StandardCloseBehavior;
import fr.skytasul.quests.api.gui.layout.LayoutedButton;
import fr.skytasul.quests.api.gui.layout.LayoutedClickEvent;
import fr.skytasul.quests.api.gui.layout.LayoutedGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.OptionSet;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.options.QuestOptionCreator;
import fr.skytasul.quests.api.options.UpdatableOptionSet;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.questers.data.QuesterQuestData;
import fr.skytasul.quests.api.questers.events.QuesterJoinEvent;
import fr.skytasul.quests.api.quests.branches.EndingStage;
import fr.skytasul.quests.api.quests.creation.QuestCreationGui;
import fr.skytasul.quests.api.quests.creation.QuestCreationGuiClickEvent;
import fr.skytasul.quests.api.quests.events.QuestCreateEvent;
import fr.skytasul.quests.api.stages.AbstractStage;
import fr.skytasul.quests.api.stages.creation.StageCreationContext;
import fr.skytasul.quests.api.utils.messaging.DefaultErrors;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.gui.creation.QuestCreationSession;
import fr.skytasul.quests.gui.creation.stages.StageCreationContextImplementation;
import fr.skytasul.quests.gui.creation.stages.StagesGUI;
import fr.skytasul.quests.options.OptionName;
import fr.skytasul.quests.structure.QuestBranchImplementation;
import fr.skytasul.quests.structure.QuestImplementation;
import fr.skytasul.quests.structure.QuestsManagerImplementation;
import fr.skytasul.quests.structure.StageControllerImplementation;
import fr.skytasul.quests.utils.QuestUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuestCreationGuiImplementation
extends LayoutedGUI
implements QuestCreationGui {
    private final QuestCreationSession session;
    private final UpdatableOptionSet options;
    private final int doneButtonSlot = 5;
    private final Map<QuestOptionCreator, LayoutedButton> optionButtons = new HashMap<QuestOptionCreator, LayoutedButton>();
    private boolean keepPlayerDatas = true;

    public QuestCreationGuiImplementation(QuestCreationSession session) {
        super(new HashMap<Integer, LayoutedButton>(), StandardCloseBehavior.CONFIRM);
        this.session = session;
        this.options = new UpdatableOptionSet();
        this.buttons.put(3, LayoutedButton.create(QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getPreviousPage(), event -> session.openStagesGUI(event.getPlayer())));
        this.buttons.put(5, LayoutedButton.create(() -> {
            boolean finishable = this.isFinishable();
            XMaterial type = finishable ? XMaterial.GOLD_INGOT : XMaterial.NETHER_BRICK;
            String itemName = (finishable ? ChatColor.GOLD : ChatColor.DARK_PURPLE).toString() + (session.isEdition() ? Lang.editQuestName : Lang.create).toString();
            ArrayList<String> lore = new ArrayList<String>(3);
            lore.add(QuestOption.formatDescription(Lang.createLore.toString()) + (finishable ? " \u00a7a\u2714" : " \u00a7c\u2716"));
            if (Boolean.FALSE.equals(this.keepPlayerDatas)) {
                lore.add("");
                lore.add(Lang.resetLore.toString());
            }
            return ItemUtils.item(type, itemName, lore);
        }, event -> {
            if (this.isFinishable()) {
                this.finish();
            }
        }));
        if (session.isEdition()) {
            this.keepPlayerDatas = true;
            this.buttons.put(6, LayoutedButton.createSwitch(() -> this.keepPlayerDatas, Lang.keepDatas.toString(), Arrays.asList(QuestOption.formatDescription(Lang.keepDatasLore.toString())), event -> {
                this.keepPlayerDatas = ItemUtils.toggleSwitch(event.getClicked());
                this.refresh(5);
            }));
        }
        this.addOptionsButtons();
        this.options.getWrapper(OptionName.class).dependent.add(() -> super.refresh(5));
    }

    private void addOptionsButtons() {
        int availableSlot = QuestsAPI.getAPI().getQuestOptions().stream().mapToInt(x -> x.preferedSlot).max().orElse(0) + 1;
        for (QuestOptionCreator<?, ?> creator : QuestsAPI.getAPI().getQuestOptions()) {
            Object option = this.session.isEdition() && this.session.getQuestEdited().hasOption(creator.optionClass) ? ((QuestOption)this.session.getQuestEdited().getOption(creator.optionClass)).clone() : (QuestOption)creator.optionSupplier.get();
            LayoutedButton.ItemButton optionButton = new LayoutedButton.ItemButton(){
                final /* synthetic */ QuestOption val$option;
                {
                    this.val$option = questOption;
                }

                @Override
                public void click(@NotNull LayoutedClickEvent event) {
                    this.val$option.click(new QuestCreationGuiClickEvent(event.getPlayer(), QuestCreationGuiImplementation.this, event.getClicked(), event.getCursor(), event.getSlot(), event.getClick()));
                }

                @Override
                @Nullable
                public ItemStack getItem() {
                    return this.val$option.getItemStack(QuestCreationGuiImplementation.this.options);
                }

                @Override
                public boolean isValid() {
                    return this.val$option.shouldDisplay(QuestCreationGuiImplementation.this.options);
                }
            };
            int slot = creator.preferedSlot;
            if (this.buttons.containsKey(slot)) {
                slot = availableSlot++;
            }
            this.buttons.put(slot, optionButton);
            this.optionButtons.put(creator, optionButton);
            this.options.addOption((QuestOption)option, () -> this.lambda$addOptionsButtons$7((QuestOption)option, optionButton));
        }
        this.options.calculateDependencies();
    }

    @Override
    protected Inventory instanciate(@NotNull Player player) {
        Object invName = Lang.INVENTORY_DETAILS.toString();
        if (this.session.isEdition()) {
            invName = (String)invName + " #" + this.session.getQuestEdited().getId();
        }
        int maxSlot = this.buttons.keySet().stream().mapToInt(Integer::intValue).max().orElse(0);
        int rows = (int)(Math.floor((double)maxSlot / 9.0) + 1.0);
        return Bukkit.createInventory(null, (int)(rows * 9), (String)invName);
    }

    private boolean isFinishable() {
        return this.options.getOption(OptionName.class).getValue() != null;
    }

    @Override
    @NotNull
    public OptionSet getOptionSet() {
        return this.options;
    }

    @Override
    public void updateOptionItem(@NotNull QuestOption<?> option) {
        this.refresh(this.optionButtons.get(option.getOptionCreator()));
    }

    private void finish() {
        QuestImplementation qu;
        QuestsManagerImplementation manager = BeautyQuests.getInstance().getQuestsManager();
        if (this.session.isEdition()) {
            QuestsPlugin.getPlugin().getLoggerExpanded().debug("Editing quest " + this.session.getQuestEdited().getId() + " with keep datas: " + this.keepPlayerDatas);
            this.session.getQuestEdited().delete(true, true);
            qu = new QuestImplementation(manager, this.session.getQuestEdited().getId(), this.session.getQuestEdited().getFile());
        } else {
            qu = manager.createQuest(this.session.hasCustomID() ? OptionalInt.of(this.session.getCustomID()) : OptionalInt.empty());
        }
        for (QuestOption option : this.options) {
            if (!option.hasCustomValue()) continue;
            qu.addOption(option);
        }
        QuestBranchImplementation mainBranch = new QuestBranchImplementation(qu.getBranchesManager());
        qu.getBranchesManager().addBranch(mainBranch);
        boolean failure = this.loadBranch(mainBranch, this.session.getStagesGUI());
        QuestCreateEvent event = new QuestCreateEvent(qu, this.session.isEdition(), this.session.getPlayer());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            qu.delete(true, false);
            Lang.CANCELLED.send((CommandSender)this.session.getPlayer());
        } else {
            if (this.session.areStagesEdited()) {
                if (this.keepPlayerDatas) {
                    QuestsPlugin.getPlugin().getLoggerExpanded().warning("Players quests datas will be kept for quest #" + qu.getId() + " - this may cause datas issues.");
                } else {
                    BeautyQuests.getInstance().getQuesterManager().getDataManager().resetQuestData(this.session.getQuestEdited().getId()).whenComplete(QuestsPlugin.getPlugin().getLoggerExpanded().logError("An error occurred while removing player datas after quest edition", this.session.getPlayerAudience(), new Object[0]));
                }
            }
            QuestsAPI.getAPI().getQuestsManager().addQuest(qu);
            Lang msg = this.session.isEdition() ? Lang.SUCCESFULLY_EDITED : Lang.SUCCESFULLY_CREATED;
            msg.send((CommandSender)this.session.getPlayer(), qu, PlaceholderRegistry.of("quest_branches", qu.getBranchesManager().getBranches().size()));
            QuestUtils.playPluginSound(this.session.getPlayerAudience(), "ENTITY_VILLAGER_YES", 1.0f);
            QuestsPlugin.getPlugin().getLoggerExpanded().info("New quest created: {}, ID {}, by {}", qu.getName(), qu.getId(), this.session.getPlayer().getName());
            if (this.session.isEdition()) {
                QuestsPlugin.getPlugin().getLoggerExpanded().info("Quest " + qu.getName() + " has been edited");
                if (failure) {
                    BeautyQuests.getInstance().createQuestBackup(qu.getFile().toPath(), "Error occurred while editing");
                }
            }
            try {
                qu.saveToFile();
            }
            catch (Exception e) {
                DefaultErrors.sendGeneric(this.session.getPlayerAudience(), "initial quest save");
                QuestsPlugin.getPlugin().getLoggerExpanded().severe("Error when trying to save newly created quest.", e);
            }
            if (this.keepPlayerDatas) {
                this.keepDatas(qu);
            }
            QuestsAPI.getAPI().propagateQuestsHandlers(handler -> {
                if (this.session.isEdition()) {
                    handler.questEdit(qu, this.session.getQuestEdited(), this.keepPlayerDatas);
                } else {
                    handler.questCreate(qu);
                }
            });
        }
        this.close(this.session.getPlayer());
    }

    private void keepDatas(QuestImplementation qu) {
        for (Quester quester : QuestsAPI.getAPI().getQuesterManager().getLoadedQuesters()) {
            quester.getDataHolder().getQuestDataIfPresent(qu).filter(QuesterQuestData::hasStarted).ifPresent(data -> {
                QuestBranchImplementation branch = qu.getBranchesManager().getBranch(data.getBranch().getAsInt());
                for (Player player : quester.getOnlinePlayers()) {
                    QuesterJoinEvent joinEvent = new QuesterJoinEvent(quester, player, false);
                    if (data.getState() == QuesterQuestData.State.IN_ENDING_STAGES) {
                        for (EndingStage endingStage : branch.getEndingStages()) {
                            ((StageControllerImplementation)endingStage.getStage()).onJoin(joinEvent);
                        }
                        continue;
                    }
                    if (data.getState() != QuesterQuestData.State.IN_REGULAR_STAGE) continue;
                    ((StageControllerImplementation)branch.getRegularStage(data.getStage().getAsInt())).onJoin(joinEvent);
                }
            });
        }
    }

    private boolean loadBranch(QuestBranchImplementation branch, StagesGUI stagesGui) {
        boolean failure = false;
        for (StageCreationContextImplementation context : stagesGui.getStageCreations()) {
            try {
                StageControllerImplementation stage = this.createStage(context, branch);
                if (context.isEndingStage()) {
                    StagesGUI newGUI = context.getEndingBranch();
                    QuestBranchImplementation newBranch = null;
                    if (!newGUI.isEmpty()) {
                        newBranch = new QuestBranchImplementation(branch.getManager());
                        branch.getManager().addBranch(newBranch);
                        failure |= this.loadBranch(newBranch, newGUI);
                    }
                    branch.addEndStage(stage, newBranch);
                    continue;
                }
                branch.addRegularStage(stage);
            }
            catch (Exception ex) {
                failure = true;
                DefaultErrors.sendGeneric(this.session.getPlayerAudience(), " lineToStage");
                QuestsPlugin.getPlugin().getLoggerExpanded().severe("An error occurred wheh creating branch from GUI.", ex);
            }
        }
        return failure;
    }

    public <T extends AbstractStage> StageControllerImplementation<T> createStage(StageCreationContext<T> context, QuestBranchImplementation branch) {
        StageControllerImplementation<T> controller = new StageControllerImplementation<T>(branch, context.getType());
        T stage = context.getCreation().finish(controller);
        controller.setStage(stage);
        return controller;
    }

    private /* synthetic */ void lambda$addOptionsButtons$7(QuestOption option, LayoutedButton.ItemButton optionButton) {
        option.onDependenciesUpdated(this.options);
        this.refresh(optionButton);
    }
}

