/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.creation.stages;

import fr.skytasul.quests.api.stages.AbstractStage;
import fr.skytasul.quests.api.stages.StageType;
import fr.skytasul.quests.api.stages.creation.StageCreation;
import fr.skytasul.quests.api.stages.creation.StageCreationContext;
import fr.skytasul.quests.api.stages.creation.StageGuiLine;
import fr.skytasul.quests.gui.creation.stages.StagesGUI;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StageCreationContextImplementation<T extends AbstractStage>
implements StageCreationContext<T> {
    @NotNull
    private final StageGuiLine line;
    @NotNull
    private final StageType<T> type;
    @NotNull
    private final StagesGUI gui;
    private final boolean ending;
    @Nullable
    private StagesGUI endingBranch;
    @Nullable
    private StageCreation<T> creation;

    public StageCreationContextImplementation(@NotNull StageGuiLine line, @NotNull StageType<T> type, boolean ending, StagesGUI gui) {
        this.line = line;
        this.type = type;
        this.ending = ending;
        this.gui = gui;
    }

    @Override
    @NotNull
    public StageGuiLine getLine() {
        return this.line;
    }

    @Override
    @NotNull
    public StageType<T> getType() {
        return this.type;
    }

    @Override
    public boolean isEndingStage() {
        return this.ending;
    }

    @Nullable
    public StagesGUI getEndingBranch() {
        return this.endingBranch;
    }

    public void setEndingBranch(StagesGUI endingBranch) {
        this.endingBranch = endingBranch;
    }

    @Override
    @NotNull
    public StageCreation<T> getCreation() {
        return Objects.requireNonNull(this.creation);
    }

    void setCreation(StageCreation<T> creation) {
        this.creation = creation;
    }

    @Override
    public void remove() {
        this.gui.deleteStageLine(this.line);
    }

    @Override
    public void reopenGui() {
        this.gui.reopen();
    }

    @Override
    public void removeAndReopenGui() {
        this.gui.deleteStageLine(this.line);
        this.gui.reopen();
    }
}

