/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.creation.stages;

import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.stages.creation.StageGuiClickHandler;
import fr.skytasul.quests.api.stages.creation.StageGuiLine;
import fr.skytasul.quests.gui.creation.stages.StagesGUI;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StageLineImplementation
implements StageGuiLine {
    @NotNull
    private final StagesGUI.Line line;
    @NotNull
    private final Map<Integer, LineItem> items = new HashMap<Integer, LineItem>();
    private int page;
    private int maxPage;

    public StageLineImplementation(StagesGUI.Line line) {
        this.line = line;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    @Nullable
    public ItemStack getItem(int slot) {
        if (!this.isSlotShown(slot)) {
            return this.items.get((Object)Integer.valueOf((int)slot)).item;
        }
        return this.getRawItem(this.getRawLineSlot(slot));
    }

    @Override
    public int setItem(int slot, @NotNull ItemStack item, @Nullable StageGuiClickHandler click) {
        boolean pageArrowChanged;
        while (this.items.containsKey(slot)) {
            ++slot;
        }
        this.items.put(slot, new LineItem(item, click));
        boolean wasSinglePage = this.maxPage == 0;
        this.computeMaxPage();
        boolean bl = pageArrowChanged = wasSinglePage && this.maxPage > 0;
        if (pageArrowChanged || this.isSlotShown(slot)) {
            this.refresh();
        }
        return slot;
    }

    @Override
    public void refreshItem(int slot, @NotNull ItemStack item) {
        this.items.get((Object)Integer.valueOf((int)slot)).item = item;
        if (this.isSlotShown(slot)) {
            this.refresh();
        }
    }

    @Override
    public void removeItem(int slot) {
        boolean pageArrowChanged;
        this.items.remove(slot);
        boolean wasMultiplePage = this.maxPage != 0;
        this.computeMaxPage();
        boolean bl = pageArrowChanged = wasMultiplePage && this.maxPage == 0;
        if (pageArrowChanged || this.isSlotShown(slot)) {
            this.refresh();
        }
    }

    public void clearItems() {
        this.items.clear();
        this.maxPage = 0;
        this.page = 0;
        this.clearLine();
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public void setPage(int page) {
        int pageFirst;
        if (!this.isShown()) {
            return;
        }
        this.clearLine();
        this.page = page;
        int n = pageFirst = page == 0 ? 0 : 1 + page * 7;
        int pageCapacity = page == 0 ? (this.maxPage == 0 ? 9 : 8) : 7;
        int rawSlot = page == 0 ? 0 : 1;
        for (int slot = pageFirst; slot < pageFirst + pageCapacity; ++slot) {
            LineItem item = this.items.get(slot);
            if (item != null) {
                this.setRawItem(rawSlot, item.item);
                item.item = this.getRawItem(rawSlot);
            }
            ++rawSlot;
        }
        if (page > 0) {
            this.setRawItem(0, QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getPreviousPage());
        }
        if (page < this.maxPage) {
            this.setRawItem(8, QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getNextPage());
        }
    }

    @Override
    public StageGuiClickHandler getClick(int rawSlot) {
        if (rawSlot == 0 && this.page > 0) {
            this.setPage(this.page - 1);
            return null;
        }
        if (rawSlot == 8 && this.page < this.maxPage) {
            this.setPage(this.page + 1);
            return null;
        }
        int slot = (this.page == 0 ? 0 : this.page * 7) + rawSlot;
        LineItem item = this.items.get(slot);
        return item == null ? null : item.handler;
    }

    private void computeMaxPage() {
        int last = this.items.keySet().stream().mapToInt(Integer::intValue).max().orElse(0);
        this.maxPage = last <= 8 ? 0 : (int)Math.ceil(((double)last - 8.0 + 1.0) / 7.0);
        if (this.page > this.maxPage) {
            this.page = this.maxPage;
        }
    }

    private boolean isShown() {
        return this.line.isShown();
    }

    private boolean isSlotShown(int slot) {
        int pageFirst = this.page == 0 ? 0 : 8 + this.page * 7;
        int pageCapacity = this.page == 0 ? 8 : 7;
        return this.isShown() && slot >= pageFirst && slot < pageFirst + pageCapacity;
    }

    public void refresh() {
        this.setPage(this.page);
    }

    private int getRawLineSlot(int slot) {
        if (slot < 8) {
            if (this.page != 0) {
                return -1;
            }
            return slot;
        }
        int slotPage = (int)(1.0 + Math.ceil(((double)slot - 8.0 + 1.0) / 7.0));
        if (slotPage != this.page) {
            return -1;
        }
        return slot - 8 - (slotPage - 1) * 7;
    }

    private void clearLine() {
        if (!this.isShown()) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            this.setRawItem(i, null);
        }
    }

    private void setRawItem(int rawSlot, ItemStack item) {
        if (!this.isShown()) {
            throw new IllegalStateException();
        }
        this.line.setItem(rawSlot, item);
    }

    private ItemStack getRawItem(int rawSlot) {
        if (!this.isShown()) {
            throw new IllegalStateException();
        }
        return this.line.getItem(rawSlot);
    }

    class LineItem {
        ItemStack item;
        StageGuiClickHandler handler;

        public LineItem(ItemStack item, StageGuiClickHandler handler) {
            this.item = item;
            this.handler = handler;
        }
    }
}

