/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.creation.stages;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.gui.AbstractGui;
import fr.skytasul.quests.api.gui.GuiClickEvent;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.close.CloseBehavior;
import fr.skytasul.quests.api.gui.close.StandardCloseBehavior;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.quests.branches.EndingStage;
import fr.skytasul.quests.api.quests.branches.QuestBranch;
import fr.skytasul.quests.api.stages.AbstractStage;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.StageType;
import fr.skytasul.quests.api.stages.creation.StageCreation;
import fr.skytasul.quests.api.stages.creation.StageGuiClickEvent;
import fr.skytasul.quests.api.stages.creation.StageGuiClickHandler;
import fr.skytasul.quests.api.stages.creation.StageGuiLine;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.gui.creation.QuestCreationSession;
import fr.skytasul.quests.gui.creation.stages.StageCreationContextImplementation;
import fr.skytasul.quests.gui.creation.stages.StageLineImplementation;
import fr.skytasul.quests.structure.QuestBranchImplementation;
import fr.skytasul.quests.utils.QuestUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StagesGUI
extends AbstractGui {
    private static final int SLOT_FINISH = 52;
    private static final ItemStack stageCreate = ItemUtils.item(XMaterial.SLIME_BALL, Lang.stageCreate.toString(), new String[0]);
    private static final ItemStack notDone = ItemUtils.lore(QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getNotDone().clone(), Lang.cantFinish.toString());
    private List<Line> lines = new ArrayList<Line>();
    private final QuestCreationSession session;
    private final StagesGUI previousBranch;
    int page;
    private boolean stop = false;

    public StagesGUI(QuestCreationSession session) {
        this(session, null);
    }

    public StagesGUI(QuestCreationSession session, StagesGUI previousBranch) {
        this.session = session;
        this.previousBranch = previousBranch;
    }

    @Override
    protected Inventory instanciate(@NotNull Player player) {
        return Bukkit.createInventory(null, (int)54, (String)Lang.INVENTORY_STAGES.toString());
    }

    @Override
    protected void populate(@NotNull Player player, @NotNull Inventory inv) {
        this.page = 0;
        for (int i = 0; i < 20; ++i) {
            this.lines.add(new Line(i, i >= 15));
        }
        this.lines.get(0).setCreationState();
        this.lines.get(15).setCreationState();
        inv.setItem(45, QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getPreviousPage());
        inv.setItem(50, QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getNextPage());
        inv.setItem(52, this.isEmpty() ? notDone : QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getDone());
        inv.setItem(53, this.previousBranch == null ? QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getCancel() : ItemUtils.item(XMaterial.FILLED_MAP, Lang.previousBranch.toString(), new String[0]));
        this.refresh();
        if (this.session.isEdition() && this == this.session.getStagesGUI()) {
            this.editBranch(this.session.getQuestEdited().getBranchesManager().getBranch(0));
            inv.setItem(52, QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getDone());
        }
    }

    public QuestCreationSession getSession() {
        return this.session;
    }

    public void reopen() {
        this.reopen(this.session.getPlayer());
    }

    private String[] getLineManageLore(int line) {
        return new String[]{"\u00a77" + String.valueOf(Lang.ClickRight) + "/" + String.valueOf(Lang.ClickLeft) + " > \u00a7c" + Lang.stageRemove.toString(), line == 0 || line == 15 ? "\u00a78" + String.valueOf(Lang.ClickShiftRight) + " > " + String.valueOf(Lang.stageUp) : "\u00a77" + String.valueOf(Lang.ClickShiftRight) + " > \u00a7e" + String.valueOf(Lang.stageUp), line == 14 || line == 19 || !this.getLine(line + 1).isActive() ? "\u00a78" + String.valueOf(Lang.ClickShiftLeft) + " > " + String.valueOf(Lang.stageDown) : "\u00a77" + String.valueOf(Lang.ClickShiftLeft) + " > \u00a7e" + String.valueOf(Lang.stageDown)};
    }

    public Line getLine(int id) {
        for (Line l : this.lines) {
            if (l.lineId != id) continue;
            return l;
        }
        throw new IllegalArgumentException("Unknown line " + id);
    }

    public boolean isEmpty() {
        if (this.lines.isEmpty()) {
            return true;
        }
        return !this.getLine(0).isActive() && !this.getLine(15).isActive();
    }

    public void deleteStageLine(StageGuiLine line) {
        this.lines.stream().filter(x -> x.lineObj == line).findAny().filter(Line::isActive).ifPresent(Line::remove);
    }

    @Override
    public void onClick(@NotNull GuiClickEvent event) {
        int slot = event.getSlot();
        if (slot > 44) {
            if (slot == 45) {
                if (this.page > 0) {
                    --this.page;
                    this.refresh();
                }
            } else if (slot > 45 && slot < 50) {
                this.page = slot - 46;
                this.refresh();
            } else if (slot == 50) {
                if (this.page < 3) {
                    ++this.page;
                    this.refresh();
                }
            } else if (slot == 52) {
                if (this.isEmpty() && this.previousBranch == null) {
                    QuestUtils.playPluginSound(QuestsPlugin.getPlugin().getAudiences().player(event.getPlayer()), "ENTITY_VILLAGER_NO", 0.6f);
                } else {
                    this.session.openCreationGUI(event.getPlayer());
                }
            } else if (slot == 53) {
                if (this.previousBranch == null) {
                    this.stop = true;
                    event.close();
                    if (!this.isEmpty()) {
                        if (!this.session.isEdition()) {
                            Lang.QUEST_CANCEL.send((CommandSender)event.getPlayer());
                        } else {
                            Lang.QUEST_EDIT_CANCEL.send((CommandSender)event.getPlayer());
                        }
                    }
                } else {
                    this.previousBranch.open(event.getPlayer());
                }
            }
        } else {
            this.session.setStagesEdited();
            Line line = this.getLine((slot - slot % 9) / 9 + 5 * this.page);
            StageGuiClickHandler click = line.lineObj.getClick(line.getLineSlot(slot));
            if (click != null) {
                click.onClick(new StageGuiClickEvent(event.getPlayer(), event.getClicked(), event.getClick(), line.context));
            }
        }
    }

    @Override
    @NotNull
    public CloseBehavior onClose(@NotNull Player player) {
        return this.isEmpty() || this.stop ? StandardCloseBehavior.REMOVE : StandardCloseBehavior.REOPEN;
    }

    private void refresh() {
        for (int i = 0; i < 3; ++i) {
            this.getInventory().setItem(i + 46, ItemUtils.item(i == this.page ? XMaterial.LIME_STAINED_GLASS_PANE : XMaterial.WHITE_STAINED_GLASS_PANE, Lang.regularPage.toString(), new String[0]));
        }
        this.getInventory().setItem(49, ItemUtils.item(this.page == 3 ? XMaterial.MAGENTA_STAINED_GLASS_PANE : XMaterial.PURPLE_STAINED_GLASS_PANE, Lang.branchesPage.toString(), new String[0]));
        this.lines.forEach(l -> l.lineObj.refresh());
    }

    public List<StageCreationContextImplementation> getStageCreations() {
        return this.lines.stream().sorted(Comparator.comparingInt(line -> line.lineId)).filter(line -> line.isActive()).map(line -> line.context).collect(Collectors.toList());
    }

    private void editBranch(QuestBranchImplementation branch) {
        for (StageController stageController : branch.getRegularStages()) {
            this.getLine(branch.getRegularStageId(stageController)).setStageEdition(stageController);
        }
        for (EndingStage endingStage : branch.getEndingStages()) {
            this.getLine(15 + branch.getEndingStageId(endingStage.getStage())).setStageEdition(endingStage.getStage(), endingStage.getBranch());
        }
    }

    class Line {
        int lineId;
        final boolean ending;
        StageLineImplementation lineObj;
        StageCreationContextImplementation<?> context;

        Line(int lineId, boolean ending) {
            this.lineId = lineId;
            this.ending = ending;
            this.lineObj = new StageLineImplementation(this);
        }

        boolean isActive() {
            return this.context != null;
        }

        void setCreationState() {
            this.lineObj.clearItems();
            this.lineObj.setItem(0, stageCreate.clone(), event -> this.setSelectionState());
        }

        void setSelectionState() {
            this.lineObj.clearItems();
            int i = 0;
            for (StageType<?> type : QuestsAPI.getAPI().getStages()) {
                this.lineObj.setItem(++i, type.getItem(), event -> this.setStageCreation(type).start(event.getPlayer()));
            }
        }

        <T extends AbstractStage> StageCreation<T> setStageCreation(StageType<T> type) {
            Line next;
            this.lineObj.clearItems();
            this.context = new StageCreationContextImplementation<T>(this.lineObj, type, this.ending, StagesGUI.this);
            StageCreation<T> creation = type.getCreationSupplier().supply(this.context);
            this.context.setCreation(creation);
            creation.setupLine(this.lineObj);
            StagesGUI.this.getInventory().setItem(52, QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getDone());
            int maxStages = this.ending ? 20 : 15;
            ItemStack manageItem = ItemUtils.item(XMaterial.BARRIER, Lang.stageType.format((HasPlaceholders)type), StagesGUI.this.getLineManageLore(this.lineId));
            this.lineObj.setItem(0, manageItem, event -> {
                switch (event.getClick()) {
                    case LEFT: 
                    case RIGHT: {
                        this.remove();
                        break;
                    }
                    case SHIFT_LEFT: {
                        this.descend();
                        break;
                    }
                    case SHIFT_RIGHT: {
                        this.ascend();
                        break;
                    }
                }
            });
            if (this.lineId != maxStages - 1 && !(next = StagesGUI.this.getLine(this.lineId + 1)).isActive()) {
                next.setCreationState();
            }
            if (this.ending) {
                if (this.context.getEndingBranch() == null) {
                    this.context.setEndingBranch(new StagesGUI(StagesGUI.this.session, StagesGUI.this));
                }
                this.lineObj.setItem(14, ItemUtils.item(XMaterial.FILLED_MAP, Lang.newBranch.toString(), new String[0]), event -> this.context.getEndingBranch().open(event.getPlayer()));
            }
            if (this.lineId != 0 && this.lineId != 15) {
                StagesGUI.this.getLine(this.lineId - 1).updateLineManageLore();
            }
            return creation;
        }

        void setStageEdition(StageController stage) {
            this.setStageEdition(stage, null);
        }

        void setStageEdition(StageController stage, @Nullable QuestBranch branch) {
            StageCreation<?> creation = this.setStageCreation(stage.getStageType());
            if (branch != null) {
                this.context.getEndingBranch().repopulate(StagesGUI.this.session.getPlayer());
                this.context.getEndingBranch().editBranch((QuestBranchImplementation)branch);
            }
            creation.edit(stage.getStage());
            this.lineObj.setPage(0);
        }

        void updateLineManageLore() {
            if (this.isActive()) {
                this.lineObj.refreshItemLore(0, StagesGUI.this.getLineManageLore(this.lineId));
            }
        }

        boolean isFirst() {
            return this.lineId == 0 || this.lineId == 15;
        }

        boolean isLast() {
            return this.lineId == 14 || this.lineId == 19;
        }

        void remove() {
            int maxStages;
            this.context = null;
            int n = maxStages = this.ending ? 20 : 15;
            if (this.lineId != maxStages - 1) {
                this.lineObj.clearItems();
                int oldId = this.lineId;
                Line lastLine = this;
                for (int i = this.lineId + 1; i < maxStages; ++i) {
                    Line nextLine = StagesGUI.this.getLine(i);
                    nextLine.exchangeLines(lastLine);
                    if (nextLine.isActive()) continue;
                    if (!nextLine.lineObj.isEmpty()) break;
                    nextLine.setCreationState();
                    break;
                }
                if (oldId == 0 || oldId == 15) {
                    StagesGUI.this.getLine(oldId).updateLineManageLore();
                }
            } else {
                this.setCreationState();
            }
            if (!this.isFirst()) {
                StagesGUI.this.getLine(this.lineId - 1).updateLineManageLore();
            }
            if (StagesGUI.this.isEmpty()) {
                StagesGUI.this.getInventory().setItem(52, notDone);
            }
        }

        void descend() {
            Line down;
            if (!this.isLast() && (down = StagesGUI.this.getLine(this.lineId + 1)).isActive()) {
                down.exchangeLines(this);
                this.updateLineManageLore();
                down.updateLineManageLore();
            }
        }

        void ascend() {
            if (!this.isFirst()) {
                Line up = StagesGUI.this.getLine(this.lineId - 1);
                up.exchangeLines(this);
                this.updateLineManageLore();
                up.updateLineManageLore();
            }
        }

        void exchangeLines(Line other) {
            if (other == null || other == this) {
                return;
            }
            int newLine = other.lineId;
            other.lineId = this.lineId;
            other.lineObj.refresh();
            this.lineId = newLine;
            this.lineObj.refresh();
        }

        int getRawSlot(int lineSlot) {
            return this.lineId * 9 - StagesGUI.this.page * 5 * 9 + lineSlot;
        }

        int getLineSlot(int rawSlot) {
            return rawSlot - (this.lineId * 9 - StagesGUI.this.page * 5 * 9);
        }

        public boolean isShown() {
            return this.lineId >= StagesGUI.this.page * 5 && this.lineId < (StagesGUI.this.page + 1) * 5;
        }

        public void setItem(int lineSlot, ItemStack item) {
            StagesGUI.this.getInventory().setItem(this.getRawSlot(lineSlot), item);
        }

        public ItemStack getItem(int lineSlot) {
            return StagesGUI.this.getInventory().getItem(this.getRawSlot(lineSlot));
        }
    }
}

