/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.items;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.editors.TextListEditor;
import fr.skytasul.quests.api.editors.parsers.NumberParser;
import fr.skytasul.quests.api.gui.AbstractGui;
import fr.skytasul.quests.api.gui.GuiClickEvent;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class ItemCreatorGUI
extends AbstractGui {
    private Consumer<ItemStack> run;
    private boolean allowCancel;
    private XMaterial type;
    private int amount = 1;
    private String name;
    private List<String> lore = new ArrayList<String>();
    private boolean quest = false;
    private boolean flags = false;

    public ItemCreatorGUI(Consumer<ItemStack> end, boolean allowCancel) {
        this.run = end;
        this.allowCancel = allowCancel;
    }

    @Override
    protected Inventory instanciate(@NotNull Player player) {
        return Bukkit.createInventory(null, (int)18, (String)Lang.INVENTORY_CREATOR.toString());
    }

    @Override
    protected void populate(@NotNull Player player, @NotNull Inventory inventory) {
        inventory.setItem(0, ItemUtils.item(XMaterial.GRASS_BLOCK, Lang.itemType.toString(), new String[0]));
        inventory.setItem(1, ItemUtils.item(XMaterial.REDSTONE, Lang.Amount.quickFormat("amount", 1), new String[0]));
        inventory.setItem(2, ItemUtils.itemSwitch(Lang.itemFlags.toString(), false, new String[0]));
        inventory.setItem(3, ItemUtils.item(XMaterial.NAME_TAG, Lang.itemName.toString(), new String[0]));
        inventory.setItem(4, ItemUtils.item(XMaterial.FEATHER, Lang.itemLore.toString(), new String[0]));
        inventory.setItem(6, ItemUtils.item(XMaterial.BOOK, Lang.itemQuest.toString() + " \u00a7c" + Lang.No.toString(), new String[0]));
        if (this.allowCancel) {
            inventory.setItem(8, QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getCancel());
        }
        inventory.setItem(17, QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getDone());
        inventory.getItem(17).setType(Material.COAL);
    }

    private void refresh() {
        if (this.type != null) {
            this.getInventory().setItem(13, this.build());
            if (this.getInventory().getItem(17).getType() != Material.DIAMOND) {
                this.getInventory().getItem(17).setType(Material.DIAMOND);
            }
        }
    }

    @Override
    public void onClick(GuiClickEvent event) {
        switch (event.getSlot()) {
            case 0: {
                Lang.CHOOSE_ITEM_TYPE.send((CommandSender)event.getPlayer());
                new TextEditor<XMaterial>(event.getPlayer(), event::reopen, obj -> {
                    this.type = obj;
                    event.reopen();
                    this.refresh();
                }, QuestsPlugin.getPlugin().getEditorManager().getFactory().getMaterialParser(true, false)).start();
                break;
            }
            case 1: {
                Lang.CHOOSE_ITEM_AMOUNT.send((CommandSender)event.getPlayer());
                new TextEditor<Integer>(event.getPlayer(), event::reopen, obj -> {
                    this.amount = obj;
                    ItemUtils.name(event.getClicked(), Lang.Amount.quickFormat("amount", this.amount));
                    event.reopen();
                    this.refresh();
                }, new NumberParser<Integer>(Integer.class, 1, 64)).start();
                break;
            }
            case 2: {
                this.flags = ItemUtils.toggleSwitch(event.getClicked());
                this.refresh();
                break;
            }
            case 3: {
                Lang.CHOOSE_ITEM_NAME.send((CommandSender)event.getPlayer());
                new TextEditor<String>(event.getPlayer(), event::reopen, obj -> {
                    this.name = obj;
                    event.reopen();
                    this.refresh();
                }).start();
                break;
            }
            case 4: {
                Lang.CHOOSE_ITEM_LORE.send((CommandSender)event.getPlayer());
                new TextListEditor(event.getPlayer(), list -> {
                    this.lore = list;
                    event.reopen();
                    this.refresh();
                }, this.lore).start();
                break;
            }
            case 6: {
                if (!this.quest) {
                    ItemUtils.name(event.getClicked(), Lang.itemQuest.toString() + " \u00a7a" + Lang.Yes.toString());
                    this.quest = true;
                } else {
                    ItemUtils.name(event.getClicked(), Lang.itemQuest.toString() + " \u00a7c" + Lang.No.toString());
                    this.quest = false;
                }
                this.refresh();
                break;
            }
            case 8: {
                this.close(event.getPlayer());
                this.run.accept(null);
                break;
            }
            case 17: {
                if (event.getClicked().getType() != Material.DIAMOND) break;
                this.close(event.getPlayer());
                this.run.accept(this.build());
                break;
            }
            case 13: {
                if (this.type == null) break;
                event.getPlayer().setItemOnCursor(this.build());
            }
        }
    }

    private ItemStack build() {
        ItemStack is = this.type.parseItem();
        ItemMeta im = is.getItemMeta();
        if (this.name != null) {
            im.setDisplayName(this.name);
        }
        if (this.flags) {
            ItemUtils.addSpecificFlags(im, is.getType());
        }
        is.setItemMeta(im);
        is.setAmount(this.amount);
        if (this.lore != null) {
            ItemUtils.lore(is, this.lore);
        }
        if (this.quest) {
            ItemUtils.loreAdd(is, " ", Lang.QuestItemLore.toString());
        }
        return is;
    }
}

