/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.items;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.gui.AbstractGui;
import fr.skytasul.quests.api.gui.GuiClickEvent;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.close.CloseBehavior;
import fr.skytasul.quests.api.gui.close.StandardCloseBehavior;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.utils.Utils;
import fr.skytasul.quests.utils.QuestUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemsGUI
extends AbstractGui {
    public static ItemStack none = ItemUtils.item(XMaterial.RED_STAINED_GLASS_PANE, "\u00a7c", Lang.itemsNone.toString());
    private Consumer<List<ItemStack>> end;
    private Map<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
    private int size;

    public ItemsGUI(Consumer<List<ItemStack>> end, List<ItemStack> itemsList) {
        this.end = end;
        Utils.extractItems(itemsList).forEach(item -> this.items.put(this.items.size(), (ItemStack)item));
        this.size = (int)(Math.ceil(((double)this.items.size() + 1.0) / 9.0) * 9.0);
    }

    @Override
    protected Inventory instanciate(@NotNull Player player) {
        return Bukkit.createInventory(null, (int)this.size, (String)Lang.INVENTORY_ITEMS.toString());
    }

    @Override
    protected void populate(@NotNull Player player, @NotNull Inventory inv) {
        inv.setItem(this.size - 1, QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getDone());
        for (int i = 0; i < this.size - 1; ++i) {
            if (i < this.items.size()) {
                inv.setItem(i, this.items.get(i));
                continue;
            }
            inv.setItem(i, none);
        }
    }

    private boolean addItem(Player p, ItemStack item, int slot) {
        this.items.put(slot, item);
        for (int i = 0; i < this.size - 1; ++i) {
            ItemStack is = this.getInventory().getItem(i);
            if (!is.equals((Object)none)) continue;
            return false;
        }
        this.size += 9;
        this.reopen(p, true);
        return true;
    }

    @Override
    public void onClick(@NotNull GuiClickEvent event) {
        if (event.hasCursor()) {
            if (event.getSlot() == this.size - 1) {
                return;
            }
            if (none.equals((Object)event.getClicked())) {
                this.getInventory().setItem(event.getSlot(), event.getCursor());
                QuestUtils.runSync(() -> {
                    event.getPlayer().setItemOnCursor(null);
                    this.addItem(event.getPlayer(), event.getCursor(), event.getSlot());
                });
            } else {
                QuestUtils.runSync(() -> this.items.put(event.getSlot(), event.getCursor()));
                event.setCancelled(false);
            }
        } else if (event.getSlot() == this.size - 1) {
            event.close();
            this.end.accept(this.items.values().stream().filter(x -> x != null).collect(Collectors.toList()));
        } else if (event.getClicked().equals((Object)none)) {
            QuestsPlugin.getPlugin().getGuiManager().getFactory().createItemCreator(item -> {
                if (item != null) {
                    this.getInventory().setItem(event.getSlot(), item);
                }
                if (!this.addItem(event.getPlayer(), (ItemStack)item, event.getSlot())) {
                    event.reopen();
                }
            }, true).open(event.getPlayer());
        } else {
            if (event.getClick().isLeftClick() || event.getClick().isRightClick() && event.getClicked().getAmount() == 1) {
                QuestUtils.runSync(() -> {
                    this.getInventory().setItem(event.getSlot(), none);
                    this.items.remove(event.getSlot());
                });
            } else {
                QuestUtils.runSync(() -> this.items.put(event.getSlot(), this.getInventory().getItem(event.getSlot())));
            }
            event.setCancelled(false);
        }
    }

    @Override
    public CloseBehavior onClose(Player p) {
        return StandardCloseBehavior.REOPEN;
    }
}

