/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.misc;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.editors.parsers.NumberParser;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.close.DelayCloseBehavior;
import fr.skytasul.quests.api.gui.layout.LayoutedButton;
import fr.skytasul.quests.api.gui.layout.LayoutedClickEvent;
import fr.skytasul.quests.api.gui.layout.LayoutedGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.utils.types.Command;
import java.util.HashMap;
import java.util.function.Consumer;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandGUI
extends LayoutedGUI.LayoutedRowsGUI {
    private Consumer<Command> end;
    private String cmd;
    private boolean console = false;
    private boolean parse = false;
    private int delay = 0;
    @NotNull
    private final LayoutedButton doneButton;

    public CommandGUI(Consumer<Command> end, Runnable cancel) {
        super(Lang.INVENTORY_COMMAND.toString(), new HashMap<Integer, LayoutedButton>(), new DelayCloseBehavior(cancel), 1);
        this.end = end;
        this.buttons.put(1, LayoutedButton.createLoreValue(XMaterial.COMMAND_BLOCK, Lang.commandValue.toString(), () -> this.cmd, this::commandClick));
        this.buttons.put(3, LayoutedButton.create(() -> ItemUtils.itemSwitch(Lang.commandConsole.toString(), this.console, new String[0]), this::consoleClick));
        this.buttons.put(4, LayoutedButton.create(() -> ItemUtils.itemSwitch(Lang.commandParse.toString(), this.parse, new String[0]), this::parseClick));
        this.buttons.put(5, LayoutedButton.createLoreValue(XMaterial.CLOCK, Lang.commandDelay.toString(), () -> this.delay, this::delayClick));
        ItemStack notDone = QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getNotDone();
        ItemStack done = QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getDone();
        this.doneButton = LayoutedButton.create(() -> this.cmd == null ? notDone : done, this::doneClick);
        this.buttons.put(8, this.doneButton);
    }

    public CommandGUI setFromExistingCommand(@Nullable Command cmd) {
        if (this.getInventory() != null) {
            throw new IllegalStateException("GUI has already been built");
        }
        if (cmd != null) {
            this.cmd = cmd.label;
            this.console = cmd.console;
            this.parse = cmd.parse;
            this.delay = cmd.delay;
        }
        return this;
    }

    private void commandClick(LayoutedClickEvent event) {
        Lang.COMMAND.send((CommandSender)event.getPlayer());
        new TextEditor<String>(event.getPlayer(), event::reopen, cmd -> {
            this.cmd = cmd;
            this.refresh(this.doneButton);
            event.refreshItemReopen();
        }).passNullIntoEndConsumer().useStrippedMessage().start();
    }

    private void consoleClick(LayoutedClickEvent event) {
        this.console = !this.console;
        event.refreshItem();
    }

    private void parseClick(LayoutedClickEvent event) {
        this.parse = !this.parse;
        event.refreshItem();
    }

    private void delayClick(LayoutedClickEvent event) {
        Lang.COMMAND_DELAY.send((CommandSender)event.getPlayer());
        new TextEditor<Integer>(event.getPlayer(), event::reopen, x -> {
            this.delay = x;
            event.refreshItemReopen();
        }, NumberParser.INTEGER_PARSER_POSITIVE).start();
    }

    private void doneClick(LayoutedClickEvent event) {
        if (this.cmd != null) {
            event.close();
            this.end.accept(new Command(this.cmd, this.console, this.parse, this.delay));
        }
    }
}

