/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.misc;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.templates.ListGUI;
import fr.skytasul.quests.api.gui.templates.StaticPagedGUI;
import fr.skytasul.quests.api.localization.Lang;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.DyeColor;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;

public class DamageCausesGUI
extends ListGUI<EntityDamageEvent.DamageCause> {
    private static final Map<EntityDamageEvent.DamageCause, ItemStack> MAPPED_ITEMS = new EnumMap<EntityDamageEvent.DamageCause, ItemStack>(EntityDamageEvent.DamageCause.class);
    private final Consumer<List<EntityDamageEvent.DamageCause>> end;

    public DamageCausesGUI(List<EntityDamageEvent.DamageCause> causes, Consumer<List<EntityDamageEvent.DamageCause>> end) {
        super(Lang.INVENTORY_DAMAGE_CAUSE.toString(), DyeColor.RED, causes);
        this.end = end;
    }

    @Override
    public void finish(List<EntityDamageEvent.DamageCause> objects) {
        this.end.accept(objects);
    }

    @Override
    public ItemStack getObjectItemStack(EntityDamageEvent.DamageCause object) {
        return MAPPED_ITEMS.get(object);
    }

    @Override
    public void createObject(Function<EntityDamageEvent.DamageCause, ItemStack> callback) {
        new StaticPagedGUI<EntityDamageEvent.DamageCause>(Lang.INVENTORY_DAMAGE_CAUSES_LIST.toString(), DyeColor.ORANGE, MAPPED_ITEMS, callback::apply, Enum::name).open(this.player);
    }

    static {
        for (EntityDamageEvent.DamageCause cause : EntityDamageEvent.DamageCause.values()) {
            XMaterial type = cause.name().length() <= 6 ? XMaterial.CREEPER_HEAD : (cause.name().length() < 10 ? XMaterial.ZOMBIE_HEAD : (cause.name().length() < 14 ? XMaterial.SKELETON_SKULL : XMaterial.WITHER_SKELETON_SKULL));
            MAPPED_ITEMS.put(cause, ItemUtils.item(type, "\u00a77" + cause.name(), new String[0]));
        }
    }
}

