/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.misc;

import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.npcs.BqNpc;
import fr.skytasul.quests.api.requirements.RequirementList;
import fr.skytasul.quests.options.OptionRequirements;
import fr.skytasul.quests.options.OptionStarterNPC;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ListBook {
    public static void openQuestBook(Player p) {
        ItemStack is = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta im = (BookMeta)is.getItemMeta();
        im.setTitle("Quests list");
        im.setAuthor("BeautyQuests");
        QuestsAPI.getAPI().getQuestsManager().getQuests().stream().sorted().forEach(qu -> {
            StringBuilder stb = new StringBuilder(ListBook.formatLine(Lang.BOOK_NAME.toString(), qu.getName()) + ListBook.formatLine("ID", "" + qu.getId()) + (qu.hasOption(OptionStarterNPC.class) ? ListBook.formatLine(Lang.BOOK_STARTER.toString(), ((BqNpc)qu.getOption(OptionStarterNPC.class).getValue()).getNpc().getName()) : "") + ListBook.formatLine(Lang.BOOK_SEVERAL.toString(), qu.isRepeatable() ? Lang.Yes.toString() : Lang.No.toString()) + ListBook.formatLine(Lang.BOOK_REQUIREMENTS.toString(), "" + ((RequirementList)qu.getOptionValueOrDef(OptionRequirements.class)).size()) + "\n" + ListBook.formatLine(Lang.BOOK_STAGES.toString(), "") + qu.getBranchesManager().getBranches().stream().mapToInt(branch -> branch.getRegularStages().size()).sum() + " stages in " + qu.getBranchesManager().getBranches().size() + " branches");
            im.addPage(new String[]{stb.toString()});
        });
        if (QuestsAPI.getAPI().getQuestsManager().getQuests().isEmpty()) {
            im.addPage(new String[]{Lang.BOOK_NOQUEST.toString()});
        }
        is.setItemMeta((ItemMeta)im);
        p.openBook(is);
    }

    private static String formatLine(String title, String object) {
        return String.valueOf(ChatColor.DARK_GREEN) + ChatColor.BOLD.toString() + title + " :\u00a7r " + String.valueOf(ChatColor.DARK_BLUE) + object + "\u00a7r\n";
    }
}

