/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.misc;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.editors.parsers.NumberParser;
import fr.skytasul.quests.api.gui.AbstractGui;
import fr.skytasul.quests.api.gui.GuiClickEvent;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.close.CloseBehavior;
import fr.skytasul.quests.api.gui.close.DelayCloseBehavior;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.utils.types.Title;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TitleGUI
extends AbstractGui {
    private static final int SLOT_TITLE = 0;
    private static final int SLOT_SUBTITLE = 1;
    private static final int SLOT_FADE_IN = 3;
    private static final int SLOT_STAY = 4;
    private static final int SLOT_FADE_OUT = 5;
    private Consumer<Title> end;
    private String title;
    private String subtitle;
    private int fadeIn = 10;
    private int stay = 70;
    private int fadeOut = 20;
    private boolean canFinish = false;

    public TitleGUI(Consumer<Title> end) {
        this.end = end;
    }

    public TitleGUI edit(Title edit) {
        if (edit != null) {
            this.title = edit.title;
            this.subtitle = edit.subtitle;
            this.fadeIn = edit.fadeIn;
            this.stay = edit.stay;
            this.fadeOut = edit.fadeOut;
        }
        return this;
    }

    private void updateFinishState() {
        this.canFinish = this.title != null || this.subtitle != null;
        Material material = this.canFinish ? Material.DIAMOND : Material.COAL;
        ItemStack item = this.getInventory().getItem(8);
        if (item.getType() != material) {
            item.setType(material);
        }
    }

    public void setTitle(String title) {
        this.title = title;
        ItemUtils.loreOptionValue(this.getInventory().getItem(0), title);
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
        ItemUtils.loreOptionValue(this.getInventory().getItem(1), subtitle);
    }

    public void setFadeIn(int fadeIn) {
        this.fadeIn = fadeIn;
        ItemUtils.lore(this.getInventory().getItem(3), QuestOption.formatNullableValue((Object)Lang.Ticks.quickFormat("ticks", fadeIn), fadeIn == 10));
    }

    public void setStay(int stay) {
        this.stay = stay;
        ItemUtils.lore(this.getInventory().getItem(4), QuestOption.formatNullableValue((Object)Lang.Ticks.quickFormat("ticks", stay), stay == 70));
    }

    public void setFadeOut(int fadeOut) {
        this.fadeOut = fadeOut;
        ItemUtils.lore(this.getInventory().getItem(5), QuestOption.formatNullableValue((Object)Lang.Ticks.quickFormat("ticks", fadeOut), fadeOut == 20));
    }

    @Override
    protected Inventory instanciate(@NotNull Player player) {
        return Bukkit.createInventory(null, (int)9, (String)Lang.INVENTORY_EDIT_TITLE.toString());
    }

    @Override
    protected void populate(@NotNull Player player, @NotNull Inventory inventory) {
        inventory.setItem(0, ItemUtils.item(XMaterial.NAME_TAG, Lang.title_title.toString(), new String[0]));
        inventory.setItem(1, ItemUtils.item(XMaterial.NAME_TAG, Lang.title_subtitle.toString(), new String[0]));
        inventory.setItem(3, ItemUtils.item(XMaterial.CLOCK, Lang.title_fadeIn.toString(), new String[0]));
        inventory.setItem(4, ItemUtils.item(XMaterial.CLOCK, Lang.title_stay.toString(), new String[0]));
        inventory.setItem(5, ItemUtils.item(XMaterial.CLOCK, Lang.title_fadeOut.toString(), new String[0]));
        inventory.setItem(7, QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getCancel());
        inventory.setItem(8, QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getDone());
        this.setTitle(this.title);
        this.setSubtitle(this.subtitle);
        this.setFadeIn(this.fadeIn);
        this.setStay(this.stay);
        this.setFadeOut(this.fadeOut);
        this.updateFinishState();
    }

    @Override
    public void onClick(GuiClickEvent event) {
        switch (event.getSlot()) {
            case 0: {
                this.startStringEditor(event.getPlayer(), Lang.TITLE_TITLE, this::setTitle);
                break;
            }
            case 1: {
                this.startStringEditor(event.getPlayer(), Lang.TITLE_SUBTITLE, this::setSubtitle);
                break;
            }
            case 3: {
                this.startIntEditor(event.getPlayer(), Lang.TITLE_FADEIN, this::setFadeIn);
                break;
            }
            case 4: {
                this.startIntEditor(event.getPlayer(), Lang.TITLE_STAY, this::setStay);
                break;
            }
            case 5: {
                this.startIntEditor(event.getPlayer(), Lang.TITLE_FADEOUT, this::setFadeOut);
                break;
            }
            case 7: {
                this.close(event.getPlayer());
                this.end.accept(null);
                break;
            }
            case 8: {
                this.close(event.getPlayer());
                this.end.accept(new Title(this.title, this.subtitle, this.fadeIn, this.stay, this.fadeOut));
                break;
            }
        }
    }

    @Override
    public CloseBehavior onClose(Player p) {
        return new DelayCloseBehavior(() -> this.end.accept(null));
    }

    private void startStringEditor(Player p, Lang helpMsg, Consumer<String> setter) {
        helpMsg.send((CommandSender)p);
        new TextEditor<String>(p, () -> this.reopen(p), msg -> {
            setter.accept((String)msg);
            this.updateFinishState();
            this.reopen(p);
        }).passNullIntoEndConsumer().start();
    }

    private void startIntEditor(Player p, Lang helpMsg, Consumer<Integer> setter) {
        helpMsg.send((CommandSender)p);
        new TextEditor<Integer>(p, () -> this.reopen(p), msg -> {
            setter.accept((Integer)msg);
            this.reopen(p);
        }, NumberParser.INTEGER_PARSER_POSITIVE).start();
    }
}

