/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.mobs;

import fr.skytasul.quests.api.gui.close.CloseBehavior;
import fr.skytasul.quests.api.gui.close.DelayCloseBehavior;
import fr.skytasul.quests.api.gui.templates.PagedGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.mobs.MobFactory;
import fr.skytasul.quests.mobs.Mob;
import java.util.function.Consumer;
import org.bukkit.DyeColor;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class MobSelectionGUI
extends PagedGUI<MobFactory<?>> {
    private Consumer<Mob<?>> end;

    public MobSelectionGUI(Consumer<Mob<?>> end) {
        super(Lang.INVENTORY_MOBSELECT.toString(), DyeColor.LIME, MobFactory.factories);
        this.end = end;
    }

    @Override
    public ItemStack getItemStack(MobFactory<?> object) {
        return object.getFactoryItem();
    }

    @Override
    public void click(MobFactory<?> existing, ItemStack item, ClickType clickType) {
        existing.itemClick(this.player, mobData -> this.end.accept(mobData == null ? null : new Mob<Object>(existing, mobData)));
    }

    @Override
    public CloseBehavior onClose(Player p) {
        return new DelayCloseBehavior(() -> this.end.accept(null));
    }
}

