/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.mobs;

import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.editors.parsers.NumberParser;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.gui.templates.ListGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.mobs.LeveledMobFactory;
import fr.skytasul.quests.api.utils.CountableObject;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.gui.mobs.MobSelectionGUI;
import fr.skytasul.quests.mobs.Mob;
import fr.skytasul.quests.utils.QuestUtils;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.DyeColor;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class MobsListGUI
extends ListGUI<CountableObject.MutableCountableObject<Mob<?>>> {
    private Consumer<List<CountableObject.MutableCountableObject<Mob<?>>>> end;

    public MobsListGUI(Collection<CountableObject.MutableCountableObject<Mob<?>>> objects, Consumer<List<CountableObject.MutableCountableObject<Mob<?>>>> end) {
        super(Lang.INVENTORY_MOBS.toString(), DyeColor.ORANGE, objects);
        this.end = end;
    }

    @Override
    public void finish(List<CountableObject.MutableCountableObject<Mob<?>>> objects) {
        this.end.accept(objects);
    }

    @Override
    public void clickObject(CountableObject.MutableCountableObject<Mob<?>> mob, ItemStack item, ClickType click) {
        super.clickObject(mob, item, click);
        if (click == ClickType.RIGHT) {
            Lang.MOB_NAME.send((CommandSender)this.player);
            new TextEditor<Object>(this.player, () -> super.reopen(), name -> {
                ((Mob)mob.getObject()).setCustomName((String)name);
                this.setItems();
                this.reopen();
            }).passNullIntoEndConsumer().start();
        } else if (click == ClickType.LEFT) {
            Lang.MOB_AMOUNT.send((CommandSender)this.player);
            new TextEditor<Integer>(this.player, () -> super.reopen(), amount -> {
                mob.setAmount((int)amount);
                this.setItems();
                this.reopen();
            }, NumberParser.INTEGER_PARSER_STRICT_POSITIVE).start();
        } else if (click == ClickType.SHIFT_RIGHT) {
            if (((Mob)mob.getObject()).getFactory() instanceof LeveledMobFactory) {
                new TextEditor<boolean>(this.player, () -> super.reopen(), level -> {
                    ((Mob)mob.getObject()).setMinLevel((Double)level);
                    this.setItems();
                    this.reopen();
                }, new NumberParser<boolean>((Class<boolean>)Double.class, true, false)).start();
            } else {
                QuestUtils.playPluginSound(this.player.getLocation(), "ENTITY_VILLAGER_NO", 0.6f);
            }
        }
    }

    @Override
    public void createObject(Function<CountableObject.MutableCountableObject<Mob<?>>, ItemStack> callback) {
        new MobSelectionGUI(mob -> {
            if (mob == null) {
                this.reopen();
            } else {
                UUID uuid = UUID.nameUUIDFromBytes(mob.serialize().toString().getBytes());
                callback.apply(CountableObject.createMutable(uuid, mob, 1));
            }
        }).open(this.getViewer());
    }

    @Override
    public ItemStack getObjectItemStack(CountableObject.MutableCountableObject<Mob<?>> mob) {
        LoreBuilder loreBuilder = this.createLoreBuilder(mob).addDescription(Lang.Amount.format((HasPlaceholders)mob)).addClick(ClickType.LEFT, Lang.editAmount.toString()).addClick(ClickType.RIGHT, Lang.editMobName.toString()).addClick(ClickType.SHIFT_RIGHT, (((Mob)mob.getObject()).getFactory() instanceof LeveledMobFactory ? "" : "\u00a78\u00a7m") + Lang.setLevel.toString());
        ItemStack item = ItemUtils.item(((Mob)mob.getObject()).getMobItem(), ((Mob)mob.getObject()).getName(), loreBuilder.toLoreArray());
        item.setAmount(Math.min(mob.getAmount(), 64));
        return item;
    }
}

