/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.npc;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.editors.WaitClick;
import fr.skytasul.quests.api.gui.AbstractGui;
import fr.skytasul.quests.api.gui.GuiClickEvent;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.close.CloseBehavior;
import fr.skytasul.quests.api.gui.close.DelayCloseBehavior;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.npcs.BqInternalNpcFactory;
import fr.skytasul.quests.api.npcs.BqNpc;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.utils.Utils;
import fr.skytasul.quests.api.utils.messaging.DefaultErrors;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class NpcCreateGUI
extends AbstractGui {
    private static final ItemStack nameItem = ItemUtils.item(XMaterial.NAME_TAG, Lang.name.toString(), new String[0]);
    private static final ItemStack move = ItemUtils.item(XMaterial.MINECART, Lang.move.toString(), Lang.moveLore.toString());
    public static ItemStack validMove = ItemUtils.item(XMaterial.EMERALD, Lang.moveItem.toString(), new String[0]);
    @NotNull
    private final BqInternalNpcFactory.BqInternalNpcFactoryCreatable factory;
    @NotNull
    private final @NotNull Consumer<@NotNull BqNpc> end;
    @NotNull
    private final Runnable cancel;
    private EntityType en;
    private String name;
    private String skin;

    public NpcCreateGUI(@NotNull BqInternalNpcFactory.BqInternalNpcFactoryCreatable factory, @NotNull @NotNull Consumer<@NotNull BqNpc> end, @NotNull Runnable cancel) {
        this.factory = factory;
        this.end = end;
        this.cancel = cancel;
    }

    @Override
    protected Inventory instanciate(@NotNull Player player) {
        return Bukkit.createInventory(null, (int)9, (String)Lang.INVENTORY_NPC.toString());
    }

    @Override
    protected void populate(@NotNull Player player, @NotNull Inventory inventory) {
        inventory.setItem(0, move.clone());
        inventory.setItem(1, nameItem.clone());
        this.setName("\u00a7cno name selected");
        this.setSkin("Knight");
        this.setType(EntityType.PLAYER);
        inventory.setItem(7, QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getCancel());
        inventory.setItem(8, QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getDone());
    }

    private void setName(String name) {
        this.name = name;
        ItemUtils.lore(this.getInventory().getItem(1), QuestOption.formatNullableValue(name));
    }

    private void setType(EntityType type) {
        this.en = type;
        if (this.en == EntityType.PLAYER) {
            this.getInventory().setItem(5, ItemUtils.skull(Lang.npcType.toString(), null, QuestOption.formatNullableValue("player")));
        } else {
            this.getInventory().setItem(5, ItemUtils.item(Utils.mobItem(this.en), Lang.npcType.toString(), QuestOption.formatNullableValue(this.en.getName())));
        }
    }

    private void setSkin(String skin) {
        this.skin = skin;
        this.getInventory().setItem(3, ItemUtils.skull(Lang.skin.toString(), skin, QuestOption.formatNullableValue(skin)));
    }

    @Override
    public void onClick(GuiClickEvent event) {
        switch (event.getSlot()) {
            case 0: {
                new WaitClick(event.getPlayer(), event::reopen, validMove.clone(), event::reopen).start();
                break;
            }
            case 1: {
                Lang.NPC_NAME.send((CommandSender)event.getPlayer());
                new TextEditor<String>(event.getPlayer(), event::reopen, obj -> {
                    this.setName((String)obj);
                    event.reopen();
                }).start();
                break;
            }
            case 3: {
                Lang.NPC_SKIN.send((CommandSender)event.getPlayer());
                new TextEditor<String>(event.getPlayer(), event::reopen, obj -> {
                    if (obj != null) {
                        this.setSkin((String)obj);
                    }
                    event.reopen();
                }).useStrippedMessage().start();
                break;
            }
            case 5: {
                QuestsPlugin.getPlugin().getGuiManager().getFactory().createEntityTypeSelection(en -> {
                    this.setType((EntityType)en);
                    event.reopen();
                }, x -> x != null && this.factory.isValidEntityType((EntityType)x)).open(event.getPlayer());
                break;
            }
            case 7: {
                event.close();
                this.cancel.run();
                break;
            }
            case 8: {
                event.close();
                try {
                    this.end.accept(QuestsPlugin.getPlugin().getNpcManager().createNPC(this.factory, event.getPlayer().getLocation(), this.en, this.name, this.skin));
                    break;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    DefaultErrors.sendGeneric(QuestsPlugin.getPlugin().getAudiences().player(event.getPlayer()), "npc creation " + ex.getMessage());
                    this.cancel.run();
                }
            }
        }
    }

    @Override
    public CloseBehavior onClose(Player p) {
        return new DelayCloseBehavior(this.cancel);
    }
}

