/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.npc;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.close.CloseBehavior;
import fr.skytasul.quests.api.gui.close.DelayCloseBehavior;
import fr.skytasul.quests.api.gui.templates.PagedGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.npcs.BqInternalNpcFactory;
import java.util.Collection;
import java.util.function.Consumer;
import org.bukkit.DyeColor;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class NpcFactoryGUI
extends PagedGUI<BqInternalNpcFactory> {
    @NotNull
    private final Runnable cancel;
    @NotNull
    private final Consumer<BqInternalNpcFactory> callback;

    public NpcFactoryGUI(@NotNull Collection<BqInternalNpcFactory> objects, @NotNull Runnable cancel, @NotNull Consumer<BqInternalNpcFactory> callback) {
        super(Lang.INVENTORY_SELECT.toString(), DyeColor.LIGHT_BLUE, objects);
        this.cancel = cancel;
        this.callback = callback;
    }

    @Override
    public void open(@NotNull Player player) {
        if (this.objects.isEmpty()) {
            throw new IllegalStateException("No NPCs factory found");
        }
        if (this.objects.size() == 1) {
            this.callback.accept((BqInternalNpcFactory)this.objects.get(0));
        } else {
            super.open(player);
        }
    }

    @Override
    @NotNull
    public ItemStack getItemStack(@NotNull BqInternalNpcFactory object) {
        return ItemUtils.item(XMaterial.FILLED_MAP, "\u00a7a" + BeautyQuests.getInstance().getNpcManager().getFactoryKey(object), Lang.Amount.quickFormat("amount", object.getIDs().size()));
    }

    @Override
    public void click(@NotNull BqInternalNpcFactory existing, @NotNull ItemStack item, @NotNull ClickType clickType) {
        this.callback.accept(existing);
    }

    @Override
    @NotNull
    public CloseBehavior onClose(@NotNull Player player) {
        return new DelayCloseBehavior(this.cancel);
    }
}

