/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.particles;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.editors.parsers.ColorParser;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.close.DelayCloseBehavior;
import fr.skytasul.quests.api.gui.layout.LayoutedButton;
import fr.skytasul.quests.api.gui.layout.LayoutedClickEvent;
import fr.skytasul.quests.api.gui.layout.LayoutedGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.gui.particles.ParticleListGUI;
import fr.skytasul.quests.utils.ParticleEffect;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParticleEffectGUI
extends LayoutedGUI.LayoutedRowsGUI {
    static final List<Particle> PARTICLES = Arrays.stream(Particle.values()).filter(particle -> {
        if (particle.getDataType() == Void.class) {
            return true;
        }
        return particle.getDataType() == Particle.DustOptions.class;
    }).collect(Collectors.toList());
    @NotNull
    private final Consumer<ParticleEffect> end;
    @NotNull
    private Particle particle;
    @NotNull
    private ParticleEffect.ParticleShape shape;
    @NotNull
    private Color color;

    public ParticleEffectGUI(@NotNull Consumer<ParticleEffect> end) {
        this(end, Particle.FLAME, ParticleEffect.ParticleShape.POINT, Color.AQUA);
    }

    public ParticleEffectGUI(@NotNull Consumer<ParticleEffect> end, @NotNull ParticleEffect effect) {
        this(end, effect.getParticle(), effect.getShape(), effect.getColor());
    }

    public ParticleEffectGUI(@NotNull Consumer<ParticleEffect> end, @NotNull Particle particle, @NotNull ParticleEffect.ParticleShape shape, @Nullable Color color) {
        super(Lang.INVENTORY_PARTICLE_EFFECT.toString(), new HashMap<Integer, LayoutedButton>(), new DelayCloseBehavior(() -> end.accept(null)), 1);
        this.end = end;
        this.particle = particle;
        this.shape = shape;
        this.color = color == null ? Color.AQUA : color;
        this.initButtons();
    }

    private void initButtons() {
        this.buttons.put(1, LayoutedButton.create(XMaterial.FIREWORK_STAR, Lang.particle_shape.toString(), () -> Arrays.asList(QuestOption.formatNullableValue((Object)this.shape)), this::shapeClick));
        this.buttons.put(3, LayoutedButton.create(XMaterial.PAPER, Lang.particle_type.toString(), () -> Arrays.asList(QuestOption.formatNullableValue(this.particle)), this::particleClick));
        this.buttons.put(4, new LayoutedButton.ItemButton(){

            @Override
            public void click(@NotNull LayoutedClickEvent event) {
                ParticleEffectGUI.this.colorClick(event);
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return ItemUtils.item(XMaterial.MAGENTA_DYE, Lang.particle_color.toString(), QuestOption.formatNullableValue("RGB: " + ParticleEffectGUI.this.color.getRed() + " " + ParticleEffectGUI.this.color.getGreen() + " " + ParticleEffectGUI.this.color.getBlue()));
            }

            @Override
            public boolean isValid() {
                return ParticleEffect.canHaveColor(ParticleEffectGUI.this.particle);
            }
        });
        this.buttons.put(7, LayoutedButton.create(QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getCancel(), this::cancelClick));
        this.buttons.put(8, LayoutedButton.create(QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getDone(), this::doneClick));
    }

    private void shapeClick(LayoutedClickEvent event) {
        List<ParticleEffect.ParticleShape> shapes;
        int index = (shapes = Arrays.asList(ParticleEffect.ParticleShape.values())).indexOf((Object)this.shape);
        this.shape = shapes.get(index == shapes.size() - 1 ? 0 : index + 1);
        event.refreshItem();
    }

    private void particleClick(LayoutedClickEvent event) {
        new ParticleListGUI(existing -> {
            if (existing != null) {
                this.particle = existing;
            }
            event.refreshGuiReopen();
        }).allowCancel().open(event.getPlayer());
    }

    private void colorClick(LayoutedClickEvent event) {
        Lang.COLOR_EDITOR.send((CommandSender)event.getPlayer());
        new TextEditor<Color>(event.getPlayer(), event::reopen, newColor -> {
            this.color = newColor;
            event.refreshItemReopen();
        }, ColorParser.PARSER).start();
    }

    private void cancelClick(LayoutedClickEvent event) {
        this.end.accept(null);
    }

    private void doneClick(LayoutedClickEvent event) {
        this.end.accept(new ParticleEffect(this.particle, this.shape, this.color));
    }
}

