/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.particles;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.templates.StaticPagedGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.gui.particles.ParticleEffectGUI;
import fr.skytasul.quests.utils.ParticleEffect;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.DyeColor;
import org.bukkit.Particle;
import org.bukkit.inventory.ItemStack;

public class ParticleListGUI
extends StaticPagedGUI<Particle> {
    private static final Map<Particle, ItemStack> PARTICLES = ParticleEffectGUI.PARTICLES.stream().collect(Collectors.toMap(Function.identity(), particle -> {
        String[] stringArray;
        boolean colorable = ParticleEffect.canHaveColor(particle);
        if (colorable) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = QuestOption.formatDescription(Lang.particle_colored.toString());
        } else {
            stringArray = new String[]{};
        }
        String[] lore = stringArray;
        return ItemUtils.item(colorable ? XMaterial.MAP : XMaterial.PAPER, "\u00a7e" + particle.name(), lore);
    }));

    public ParticleListGUI(Consumer<Particle> end) {
        super(Lang.INVENTORY_PARTICLE_LIST.toString(), DyeColor.MAGENTA, PARTICLES, end, Enum::name);
        this.sortValuesByName();
    }
}

