/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.pools;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.editors.parsers.DurationParser;
import fr.skytasul.quests.api.editors.parsers.NumberParser;
import fr.skytasul.quests.api.gui.AbstractGui;
import fr.skytasul.quests.api.gui.GuiClickEvent;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.objects.QuestObjectLocation;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.pools.QuestPool;
import fr.skytasul.quests.api.requirements.AbstractRequirement;
import fr.skytasul.quests.api.requirements.RequirementList;
import fr.skytasul.quests.api.utils.Utils;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;

public class PoolEditGUI
extends AbstractGui {
    private static final int SLOT_NPC = 1;
    private static final int SLOT_HOLOGRAM = 2;
    private static final int SLOT_MAX_QUESTS = 3;
    private static final int SLOT_QUESTS_PER_LAUNCH = 4;
    private static final int SLOT_TIME = 5;
    private static final int SLOT_REDO = 6;
    private static final int SLOT_DUPLICATE = 7;
    private static final int SLOT_REQUIREMENTS = 8;
    private static final int SLOT_CANCEL = 12;
    private static final int SLOT_CREATE = 14;
    private final Runnable end;
    private String hologram;
    private int maxQuests = 1;
    private int questsPerLaunch = 1;
    private boolean redoAllowed = true;
    private long timeDiff = TimeUnit.DAYS.toMillis(1L);
    private String npcID = null;
    private boolean avoidDuplicates = true;
    private RequirementList requirements = new RequirementList();
    private QuestPool editing;

    public PoolEditGUI(Runnable end, QuestPool editing) {
        this.end = end;
        this.editing = editing;
        if (editing != null) {
            this.hologram = editing.getHologram();
            this.maxQuests = editing.getMaxQuests();
            this.questsPerLaunch = editing.getQuestsPerLaunch();
            this.redoAllowed = editing.isRedoAllowed();
            this.timeDiff = editing.getTimeDiff();
            this.npcID = editing.getNpcId();
            this.avoidDuplicates = editing.doAvoidDuplicates();
            this.requirements = editing.getRequirements();
        }
    }

    private String[] getNPCLore() {
        return new String[]{"\u00a78> " + Lang.requiredParameter.toString(), "", QuestOption.formatNullableValue("NPC " + this.npcID)};
    }

    private String[] getHologramLore() {
        return new String[]{"", this.hologram == null ? QuestOption.formatNullableValue(Lang.PoolHologramText.toString()) + " " + Lang.defaultValue.toString() : QuestOption.formatNullableValue(this.hologram)};
    }

    private String[] getMaxQuestsLore() {
        return new String[]{"", QuestOption.formatNullableValue(this.maxQuests)};
    }

    private String[] getQuestsPerLaunchLore() {
        return new String[]{"", QuestOption.formatNullableValue((Object)Integer.toString(this.questsPerLaunch), this.questsPerLaunch == 1)};
    }

    private String[] getTimeLore() {
        return new String[]{"", QuestOption.formatNullableValue(Utils.millisToHumanString(this.timeDiff))};
    }

    private String[] getRequirementsLore() {
        return new String[]{"", QuestOption.formatDescription(this.requirements.getSizeString())};
    }

    @Override
    protected Inventory instanciate(@NotNull Player player) {
        return Bukkit.createInventory(null, (int)18, (String)Lang.INVENTORY_POOL_CREATE.toString());
    }

    @Override
    protected void populate(@NotNull Player player, @NotNull Inventory inv) {
        if (QuestsPlugin.getPlugin().getNpcManager().isEnabled()) {
            inv.setItem(1, ItemUtils.item(XMaterial.VILLAGER_SPAWN_EGG, Lang.stageNPCSelect.toString(), this.getNPCLore()));
        }
        inv.setItem(2, ItemUtils.item(XMaterial.OAK_SIGN, Lang.poolEditHologramText.toString(), this.getHologramLore()));
        inv.setItem(3, ItemUtils.item(XMaterial.REDSTONE, Lang.poolMaxQuests.toString(), this.getMaxQuestsLore()));
        inv.setItem(4, ItemUtils.item(XMaterial.GUNPOWDER, Lang.poolQuestsPerLaunch.toString(), this.getQuestsPerLaunchLore()));
        inv.setItem(5, ItemUtils.item(XMaterial.CLOCK, Lang.poolTime.toString(), this.getTimeLore()));
        inv.setItem(6, ItemUtils.itemSwitch(Lang.poolRedo.toString(), this.redoAllowed, new String[0]));
        inv.setItem(7, ItemUtils.itemSwitch(Lang.poolAvoidDuplicates.toString(), this.avoidDuplicates, Lang.poolAvoidDuplicatesLore.toString()));
        inv.setItem(8, ItemUtils.item(XMaterial.NETHER_STAR, Lang.poolRequirements.toString(), this.getRequirementsLore()));
        inv.setItem(12, QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getCancel());
        inv.setItem(14, QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getDone());
    }

    @Override
    public void onClick(GuiClickEvent event) {
        switch (event.getSlot()) {
            case 1: {
                QuestsPlugin.getPlugin().getGuiManager().getFactory().createNpcSelection(event::reopen, npc -> {
                    this.npcID = npc.getId();
                    ItemUtils.lore(event.getClicked(), this.getNPCLore());
                    this.reopen(event.getPlayer());
                }, false).open(event.getPlayer());
                break;
            }
            case 2: {
                Lang.POOL_HOLOGRAM_TEXT.send((CommandSender)event.getPlayer());
                new TextEditor<String>(event.getPlayer(), event::reopen, msg -> {
                    this.hologram = msg;
                    ItemUtils.lore(event.getClicked(), this.getHologramLore());
                    this.reopen(event.getPlayer());
                }).passNullIntoEndConsumer().start();
                break;
            }
            case 3: {
                Lang.POOL_MAXQUESTS.send((CommandSender)event.getPlayer());
                new TextEditor<Integer>(event.getPlayer(), event::reopen, msg -> {
                    this.maxQuests = msg;
                    ItemUtils.lore(event.getClicked(), this.getMaxQuestsLore());
                    this.reopen(event.getPlayer());
                }, NumberParser.INTEGER_PARSER_STRICT_POSITIVE).start();
                break;
            }
            case 4: {
                Lang.POOL_QUESTS_PER_LAUNCH.send((CommandSender)event.getPlayer());
                new TextEditor<Integer>(event.getPlayer(), event::reopen, msg -> {
                    this.questsPerLaunch = msg;
                    ItemUtils.lore(event.getClicked(), this.getQuestsPerLaunchLore());
                    this.reopen(event.getPlayer());
                }, NumberParser.INTEGER_PARSER_STRICT_POSITIVE).start();
                break;
            }
            case 5: {
                Lang.POOL_TIME.send((CommandSender)event.getPlayer());
                new TextEditor<Long>(event.getPlayer(), event::reopen, msg -> {
                    this.timeDiff = msg * 1000L;
                    ItemUtils.lore(event.getClicked(), this.getTimeLore());
                    this.reopen(event.getPlayer());
                }, new DurationParser(DurationParser.MinecraftTimeUnit.SECOND, DurationParser.MinecraftTimeUnit.DAY)).start();
                break;
            }
            case 6: {
                this.redoAllowed = ItemUtils.toggleSwitch(event.getClicked());
                break;
            }
            case 7: {
                this.avoidDuplicates = ItemUtils.toggleSwitch(event.getClicked());
                break;
            }
            case 8: {
                QuestsAPI.getAPI().getRequirements().createGUI(QuestObjectLocation.POOL, newRequirements -> {
                    this.requirements = new RequirementList((Collection<AbstractRequirement>)newRequirements);
                    ItemUtils.lore(event.getClicked(), this.getRequirementsLore());
                    this.reopen(event.getPlayer());
                }, this.requirements).open(event.getPlayer());
                break;
            }
            case 12: {
                this.end.run();
                break;
            }
            case 14: {
                BeautyQuests.getInstance().getPoolsManager().createPool(this.editing, this.npcID, this.hologram, this.maxQuests, this.questsPerLaunch, this.redoAllowed, this.timeDiff, this.avoidDuplicates, this.requirements);
                this.end.run();
            }
        }
    }
}

