/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.pools;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.close.CloseBehavior;
import fr.skytasul.quests.api.gui.close.StandardCloseBehavior;
import fr.skytasul.quests.api.gui.templates.PagedGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.pools.QuestPool;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.gui.pools.PoolEditGUI;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.DyeColor;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class PoolsManageGUI
extends PagedGUI<QuestPool> {
    private static final ItemStack CREATE_POOL = ItemUtils.item(XMaterial.SLIME_BALL, Lang.poolCreate.toString(), new String[0]);

    private PoolsManageGUI(Collection<QuestPool> objects) {
        super(Lang.INVENTORY_POOLS_MANAGE.toString(), DyeColor.CYAN, objects);
    }

    @Override
    public ItemStack getItemStack(QuestPool object) {
        return object == null ? CREATE_POOL : object.getItemStack(Lang.poolEdit.toString());
    }

    @Override
    public void click(QuestPool existing, ItemStack clicked, ClickType click) {
        if (click == ClickType.SHIFT_LEFT) {
            if (existing != null) {
                BeautyQuests.getInstance().getGuiManager().getFactory().createConfirmation(() -> {
                    BeautyQuests.getInstance().getPoolsManager().removePool(existing.getId());
                    PoolsManageGUI.get().open(this.player);
                }, this::reopen, Lang.INDICATION_REMOVE_POOL.format((HasPlaceholders)existing), new String[0]).open(this.player);
            }
        } else {
            new PoolEditGUI(() -> PoolsManageGUI.get().open(this.player), existing).open(this.player);
        }
    }

    @Override
    public CloseBehavior onClose(Player p) {
        return StandardCloseBehavior.REMOVE;
    }

    public static PoolsManageGUI get() {
        ArrayList<QuestPool> pools = new ArrayList<QuestPool>(BeautyQuests.getInstance().getPoolsManager().getPools());
        pools.add(null);
        return new PoolsManageGUI(pools);
    }
}

