/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.quests;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.close.CloseBehavior;
import fr.skytasul.quests.api.gui.close.StandardCloseBehavior;
import fr.skytasul.quests.api.gui.templates.PagedGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.options.description.DescriptionSource;
import fr.skytasul.quests.api.options.description.QuestDescriptionContext;
import fr.skytasul.quests.api.players.PlayerManager;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.utils.PlayerListCategory;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.gui.quests.PlayerListGUI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.DyeColor;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ChoosePlayerQuestGUI
extends PagedGUI<Quest> {
    @NotNull
    private final Player targetPlayer;
    @NotNull
    private final Quester acc;

    public ChoosePlayerQuestGUI(@NotNull Collection<Quest> quests, @NotNull Player player) {
        super(Lang.INVENTORY_CHOOSE.toString(), DyeColor.MAGENTA, quests);
        this.targetPlayer = player;
        this.acc = PlayerManager.getPlayerAccount(player);
        Collections.sort(this.objects);
        this.setValidate(__ -> new PlayerListGUI(QuestsAPI.getAPI().getQuesterManager(), player, false).open(player), ItemUtils.item(XMaterial.BOOKSHELF, Lang.questMenu.toString(), QuestOption.formatDescription(Lang.questMenuLore.toString())));
    }

    @Override
    @NotNull
    public ItemStack getItemStack(@NotNull Quest quest) {
        List<String> lore = new QuestDescriptionContext(QuestsConfiguration.getConfig().getQuestDescriptionConfig(), quest, this.targetPlayer, this.acc, PlayerListCategory.NOT_STARTED, DescriptionSource.MENU).formatDescription();
        return ItemUtils.nameAndLore(quest.getQuestItem(), Lang.formatNormal.format((HasPlaceholders)quest), lore);
    }

    @Override
    public void click(@NotNull Quest existing, @NotNull ItemStack item, @NotNull ClickType clickType) {
        this.close();
        existing.doNpcClick(this.targetPlayer);
    }

    @Override
    @NotNull
    public CloseBehavior onClose(@NotNull Player player) {
        return StandardCloseBehavior.REMOVE;
    }
}

