/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.quests;

import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.close.CloseBehavior;
import fr.skytasul.quests.api.gui.close.DelayCloseBehavior;
import fr.skytasul.quests.api.gui.close.StandardCloseBehavior;
import fr.skytasul.quests.api.gui.templates.PagedGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.utils.QuestUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Consumer;
import org.bukkit.DyeColor;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseQuestGUI
extends PagedGUI<Quest> {
    @NotNull
    private Consumer<Quest> run;
    @Nullable
    private Runnable cancel;

    public ChooseQuestGUI(@NotNull @NotNull Collection<@NotNull Quest> quests, @NotNull @NotNull Consumer<@NotNull Quest> run, @Nullable Runnable cancel) {
        super(Lang.INVENTORY_CHOOSE.toString(), DyeColor.MAGENTA, quests);
        this.run = Objects.requireNonNull(run);
        this.cancel = cancel;
        Collections.sort(this.objects);
    }

    @Override
    public ItemStack getItemStack(Quest object) {
        return ItemUtils.nameAndLore(object.getQuestItem().clone(), Lang.formatId.format((HasPlaceholders)object), "\u00a77" + object.getDescription());
    }

    @Override
    public void click(Quest existing, ItemStack item, ClickType clickType) {
        this.close(this.player);
        QuestUtils.runSync(() -> this.run.accept(existing));
    }

    @Override
    @NotNull
    public CloseBehavior onClose(@NotNull Player player) {
        if (this.cancel != null) {
            return new DelayCloseBehavior(this.cancel);
        }
        return StandardCloseBehavior.REMOVE;
    }
}

